package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity.CrafterItemHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.logistics.chute.AbstractChuteBlock;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.minecraft.block.*;
import net.minecraft.class_10290;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_3962;
import net.minecraft.class_4969;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

import static com.zurrtum.create.Create.MOD_ID;

public class AllArmInteractionPointTypes {
    public static final BasinType BASIN = register("basin", new BasinType());
    public static final BeltType BELT = register("belt", new BeltType());
    public static final BlazeBurnerType BLAZE_BURNER = register("blaze_burner", new BlazeBurnerType());
    public static final ChuteType CHUTE = register("chute", new ChuteType());
    public static final CrafterType CRAFTER = register("crafter", new CrafterType());
    public static final CrushingWheelsType CRUSHING_WHEELS = register("crushing_wheels", new CrushingWheelsType());
    public static final DeployerType DEPLOYER = register("deployer", new DeployerType());
    public static final DepotType DEPOT = register("depot", new DepotType());
    public static final FunnelType FUNNEL = register("funnel", new FunnelType());
    public static final MillstoneType MILLSTONE = register("millstone", new MillstoneType());
    public static final PackagerType PACKAGER = register("packager", new PackagerType());
    public static final SawType SAW = register("saw", new SawType());
    public static final CampfireType CAMPFIRE = register("campfire", new CampfireType());
    public static final ComposterType COMPOSTER = register("composter", new ComposterType());
    public static final JukeboxType JUKEBOX = register("jukebox", new JukeboxType());
    public static final RespawnAnchorType RESPAWN_ANCHOR = register("respawn_anchor", new RespawnAnchorType());

    private static <T extends ArmInteractionPointType> T register(String name, T type) {
        return class_2378.method_10230(CreateRegistries.ARM_INTERACTION_POINT_TYPE, class_2960.method_60655(MOD_ID, name), type);
    }

    public static void register() {
    }

    public static class BasinType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return BasinBlock.isBasin(level, pos);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class BeltType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.BELT) && !(level.method_8320(pos.method_10084())
                .method_26204() instanceof BeltTunnelBlock) && BeltBlock.canTransportObjects(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new BeltPoint(this, level, pos, state);
        }
    }

    public static class BlazeBurnerType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.BLAZE_BURNER);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new BlazeBurnerPoint(this, level, pos, state);
        }
    }

    public static class ChuteType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AbstractChuteBlock.isChute(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class CrafterType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.MECHANICAL_CRAFTER);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new CrafterPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelsType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.CRUSHING_WHEEL_CONTROLLER);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new CrushingWheelPoint(this, level, pos, state);
        }
    }

    public static class DeployerType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.DEPLOYER);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DeployerPoint(this, level, pos, state);
        }
    }

    public static class DepotType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.DEPOT) || state.method_27852(AllBlocks.WEIGHTED_EJECTOR) || state.method_27852(AllBlocks.TRACK_STATION);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class FunnelType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_26204() instanceof AbstractFunnelBlock && !(state.method_28498(FunnelBlock.EXTRACTING) && state.method_11654(FunnelBlock.EXTRACTING)) && !(state.method_28498(
                BeltFunnelBlock.SHAPE) && state.method_11654(BeltFunnelBlock.SHAPE) == Shape.PUSHING);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new FunnelPoint(this, level, pos, state);
        }
    }

    public static class MillstoneType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.MILLSTONE);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class PackagerType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.PACKAGER) || state.method_27852(AllBlocks.REPACKAGER);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class SawType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(AllBlocks.MECHANICAL_SAW) && state.method_11654(SawBlock.FACING) == class_2350.field_11036 && ((KineticBlockEntity) level.method_8321(
                pos)).getSpeed() != 0;
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class CampfireType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_26204() instanceof class_3922;
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new CampfirePoint(this, level, pos, state);
        }
    }

    public static class ComposterType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_17563);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ComposterPoint(this, level, pos, state);
        }
    }

    public static class JukeboxType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_10223);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new JukeboxPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorType extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_23152);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new RespawnAnchorPoint(this, level, pos, state);
        }
    }

    //

    public static class DepositOnlyArmInteractionPoint extends ArmInteractionPoint {
        public DepositOnlyArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public void cycleMode() {
        }

        @Override
        public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            return class_1799.field_8037;
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 0;
        }
    }

    public static class TopFaceArmInteractionPoint extends ArmInteractionPoint {
        public TopFaceArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954(pos).method_1031(.5f, 1, .5f);
        }
    }

    public static class BeltPoint extends DepotPoint {
        public BeltPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public void keepAlive() {
            super.keepAlive();
            BeltBlockEntity beltBE = BeltHelper.getSegmentBE(level, pos);
            if (beltBE == null)
                return;
            TransportedItemStackHandlerBehaviour transport = beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null)
                return;
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue())
                    return TransportedResult.doNothing();
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedResult.doNothing();
            });
        }
    }

    public static class BlazeBurnerPoint extends DepositOnlyArmInteractionPoint {
        public BlazeBurnerPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
            class_1799 input = stack.method_7972();
            class_1269 res = BlazeBurnerBlock.tryInsert(cachedState, level, pos, input, false, false, simulate);
            class_1799 remainder = class_1799.field_8037;
            if (res instanceof class_1269.class_9860 success) {
                class_1799 newHandStack = success.method_61396();
                if (newHandStack != null && !newHandStack.method_7960()) {
                    remainder = newHandStack;
                }
            }
            if (input.method_7960()) {
                return remainder;
            } else {
                if (!simulate)
                    class_1264.method_5449(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), remainder);
                return input;
            }
        }
    }

    public static class CrafterPoint extends ArmInteractionPoint {
        public CrafterPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_2350 getInteractionDirection() {
            return cachedState.method_61767(MechanicalCrafterBlock.HORIZONTAL_FACING, class_2350.field_11035).method_10153();
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return super.getInteractionPositionVector().method_1019(class_243.method_24954(getInteractionDirection().method_62675()).method_1021(.5f));
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = cachedState;
            super.updateCachedState();
            if (oldState != cachedState)
                cachedAngles = null;
        }

        @Override
        public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            class_2586 be = level.method_8321(pos);
            if (!(be instanceof MechanicalCrafterBlockEntity crafter))
                return class_1799.field_8037;
            CrafterItemHandler inventory = crafter.getInventory();
            class_1799 stack = inventory.getStack();
            int count = stack.method_7947();
            if (count == 0) {
                return class_1799.field_8037;
            }
            if (amount >= count) {
                inventory.setStack(class_1799.field_8037);
            } else {
                stack.method_7939(count - amount);
                stack = stack.method_46651(amount);
            }
            inventory.method_5431();
            return inventory.onExtract(stack);
        }
    }

    public static class DeployerPoint extends ArmInteractionPoint {
        public DeployerPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_2350 getInteractionDirection() {
            return cachedState.method_61767(DeployerBlock.FACING, class_2350.field_11036).method_10153();
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return super.getInteractionPositionVector().method_1019(class_243.method_24954(getInteractionDirection().method_62675()).method_1021(.65f));
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = cachedState;
            super.updateCachedState();
            if (oldState != cachedState)
                cachedAngles = null;
        }
    }

    public static class DepotPoint extends ArmInteractionPoint {
        public DepotPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954(pos).method_1031(.5f, 14 / 16f, .5f);
        }
    }

    public static class FunnelPoint extends DepositOnlyArmInteractionPoint {
        public FunnelPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            class_2350 funnelFacing = FunnelBlock.getFunnelFacing(cachedState);
            class_2382 normal = funnelFacing != null ? funnelFacing.method_62675() : class_2382.field_11176;
            return VecHelper.getCenterOf(pos).method_1019(class_243.method_24954(normal).method_1021(-.15f));
        }

        @Override
        protected class_2350 getInteractionDirection() {
            class_2350 funnelFacing = FunnelBlock.getFunnelFacing(cachedState);
            return funnelFacing != null ? funnelFacing.method_10153() : class_2350.field_11036;
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = cachedState;
            super.updateCachedState();
            if (oldState != cachedState)
                cachedAngles = null;
        }

        @Override
        public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
            ServerFilteringBehaviour filtering = BlockEntityBehaviour.get(level, pos, ServerFilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = BlockEntityBehaviour.get(level, pos, InvManipulationBehaviour.TYPE);
            if (cachedState.method_61767(class_2741.field_12484, false))
                return stack;
            if (inserter == null)
                return stack;
            if (filtering != null && !filtering.test(stack))
                return stack;
            if (simulate)
                inserter.simulate();
            class_1799 insert = inserter.insert(stack);
            if (!simulate && insert.method_7947() != stack.method_7947()) {
                class_2586 blockEntity = level.method_8321(pos);
                if (blockEntity instanceof FunnelBlockEntity funnelBlockEntity) {
                    funnelBlockEntity.onTransfer(stack);
                    if (funnelBlockEntity.hasFlap())
                        funnelBlockEntity.flap(true);
                }
            }
            return insert;
        }
    }

    public static class CampfirePoint extends DepositOnlyArmInteractionPoint {
        public CampfirePoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
            class_2586 blockEntity = level.method_8321(pos);
            if (!(blockEntity instanceof class_3924 campfireBE))
                return stack;
            if (!level.method_8433().method_64678(class_10290.field_54653).method_64701(stack))
                return stack;
            if (simulate) {
                boolean hasSpace = false;
                for (class_1799 campfireStack : campfireBE.method_17505()) {
                    if (campfireStack.method_7960()) {
                        hasSpace = true;
                        break;
                    }
                }
                if (!hasSpace)
                    return stack;
                class_1799 remainder = stack.method_7972();
                remainder.method_7934(1);
                return remainder;
            }
            class_1799 remainder = stack.method_7972();
            campfireBE.method_17503((class_3218) level, null, remainder);
            return remainder;
        }
    }

    public static class ComposterPoint extends ArmInteractionPoint {
        public ComposterPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954(pos).method_1031(.5f, 13 / 16f, .5f);
        }

        @Nullable
        @Override
        protected class_1263 getHandler(ArmBlockEntity armBlockEntity) {
            class_3962 composterBlock = (class_3962) class_2246.field_17563;
            return composterBlock.method_17680(cachedState, level, pos);
        }

        @Override
        public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            class_1263 handler = getHandler(armBlockEntity);
            if (handler == null)
                return class_1799.field_8037;
            if (simulate) {
                return handler.count(stack -> true, amount, class_2350.field_11033);
            }
            return handler.extract(stack -> true, amount, class_2350.field_11033);
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 2;
        }
    }

    public static class JukeboxPoint extends TopFaceArmInteractionPoint {
        public JukeboxPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 1;
        }

        @Override
        public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
            if (stack.method_58694(class_9334.field_52175) == null)
                return stack;
            if (cachedState.method_61767(class_2387.field_11180, true))
                return stack;
            if (!(level.method_8321(pos) instanceof class_2619 jukeboxBE))
                return stack;
            if (!jukeboxBE.method_54079().method_7960())
                return stack;
            class_1799 remainder = stack.method_7972();
            class_1799 toInsert = remainder.method_7971(1);
            if (!simulate)
                jukeboxBE.method_54077(toInsert);
            return remainder;
        }

        @Override
        public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            if (!cachedState.method_61767(class_2387.field_11180, false))
                return class_1799.field_8037;
            if (!(level.method_8321(pos) instanceof class_2619 jukeboxBE))
                return class_1799.field_8037;
            if (!simulate)
                return jukeboxBE.method_5434(slot, amount);
            return jukeboxBE.method_54079();
        }
    }

    public static class RespawnAnchorPoint extends DepositOnlyArmInteractionPoint {
        public RespawnAnchorPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954(pos).method_1031(.5f, 1, .5f);
        }

        @Override
        public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
            if (!stack.method_31574(class_1802.field_8801))
                return stack;
            if (cachedState.method_61767(class_4969.field_23153, 4) == 4)
                return stack;
            if (!simulate)
                class_4969.method_26382(null, level, pos, cachedState);
            class_1799 remainder = stack.method_7972();
            remainder.method_7934(1);
            return remainder;
        }
    }

    public static class CrushingWheelPoint extends DepositOnlyArmInteractionPoint {
        public CrushingWheelPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954(pos).method_1031(.5f, 1, .5f);
        }
    }
}