package com.zurrtum.create.content.kinetics.transmission.sequencer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class SequencedGearshiftBlockEntity extends SplitShaftBlockEntity {

    public Vector<Instruction> instructions;
    int currentInstruction;
    int currentInstructionDuration;
    float currentInstructionProgress;
    int timer;
    boolean poweredPreviously;

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    public record SequenceContext(SequencerInstructions instruction, double relativeValue) {
        public static Codec<SequenceContext> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            SequencerInstructions.CODEC.fieldOf("Mode").forGetter(SequenceContext::instruction),
            Codec.DOUBLE.fieldOf("Value").forGetter(SequenceContext::relativeValue)
        ).apply(instance, SequenceContext::new));

        public static SequenceContext fromGearshift(SequencerInstructions instruction, double kineticSpeed, int absoluteValue) {
            return instruction.needsPropagation() ? new SequenceContext(instruction, kineticSpeed == 0 ? 0 : absoluteValue / kineticSpeed) : null;
        }

        public double getEffectiveValue(double speedAtTarget) {
            return Math.abs(relativeValue * speedAtTarget);
        }

        public class_2487 serializeNBT() {
            class_2487 nbt = new class_2487();
            NBTHelper.writeEnum(nbt, "Mode", instruction);
            nbt.method_10549("Value", relativeValue);
            return nbt;
        }

        public static SequenceContext fromNBT(class_2487 nbt) {
            if (nbt.method_33133())
                return null;
            return new SequenceContext(NBTHelper.readEnum(nbt, "Mode", SequencerInstructions.class), nbt.method_68563("Value", 0));
        }

    }

    public SequencedGearshiftBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SEQUENCED_GEARSHIFT, pos, state);
        instructions = Instruction.createDefault();
        currentInstruction = -1;
        currentInstructionDuration = -1;
        currentInstructionProgress = 0;
        timer = 0;
        poweredPreviously = false;
    }

    //TODO
    //    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    //        if (Mods.COMPUTERCRAFT.isLoaded()) {
    //            event.registerBlockEntity(
    //                PeripheralCapability.get(),
    //                AllBlockEntityTypes.SEQUENCED_GEARSHIFT.get(),
    //                (be, context) -> be.computerBehaviour.getPeripheralCapability()
    //            );
    //        }
    //    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        //TODO
        //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    @Override
    public void tick() {
        super.tick();

        if (isIdle())
            return;
        if (field_11863.field_9236)
            return;
        if (currentInstructionDuration < 0)
            return;
        if (timer < currentInstructionDuration) {
            timer++;
            currentInstructionProgress += getInstruction(currentInstruction).getTickProgress(speed);
            return;
        }
        run(currentInstruction + 1);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (isIdle())
            return;
        float currentSpeed = Math.abs(speed);
        if (Math.abs(previousSpeed) == currentSpeed)
            return;
        Instruction instruction = getInstruction(currentInstruction);
        if (instruction == null)
            return;
        if (getSpeed() == 0)
            run(-1);

        // Update instruction time with regards to new speed
        currentInstructionDuration = instruction.getDuration(currentInstructionProgress, getTheoreticalSpeed());
        timer = 0;
    }

    public boolean isIdle() {
        return currentInstruction == -1;
    }

    public void onRedstoneUpdate(boolean isPowered, boolean isRunning) {
        //TODO
        //        if (computerBehaviour.hasAttachedComputer())
        //            return;
        if (!poweredPreviously && isPowered)
            risingFlank();
        poweredPreviously = isPowered;
        if (!isIdle())
            return;
        if (isPowered == isRunning)
            return;
        if (!field_11863.method_49803(field_11867)) {
            field_11863.method_8652(field_11867, method_11010().method_11657(SequencedGearshiftBlock.STATE, 0), class_2248.field_31036);
            return;
        }
        if (getSpeed() == 0)
            return;
        run(0);
    }

    public void risingFlank() {
        Instruction instruction = getInstruction(currentInstruction);
        if (instruction == null)
            return;
        if (poweredPreviously)
            return;
        poweredPreviously = true;

        if (Objects.requireNonNull(instruction.onRedstonePulse()) == OnIsPoweredResult.CONTINUE) {
            run(currentInstruction + 1);
        }
    }

    public void run(int instructionIndex) {
        Instruction instruction = getInstruction(instructionIndex);
        if (instruction == null || instruction.instruction == SequencerInstructions.END) {
            if (getModifier() != 0)
                detachKinetics();
            currentInstruction = -1;
            currentInstructionDuration = -1;
            currentInstructionProgress = 0;
            sequenceContext = null;
            timer = 0;
            if (!field_11863.method_49803(field_11867))
                field_11863.method_8652(field_11867, method_11010().method_11657(SequencedGearshiftBlock.STATE, 0), class_2248.field_31036);
            else
                sendData();
            return;
        }

        detachKinetics();
        currentInstructionDuration = instruction.getDuration(0, getTheoreticalSpeed());
        currentInstruction = instructionIndex;
        currentInstructionProgress = 0;
        sequenceContext = SequenceContext.fromGearshift(instruction.instruction, getTheoreticalSpeed() * getModifier(), instruction.value);
        timer = 0;
        field_11863.method_8652(field_11867, method_11010().method_11657(SequencedGearshiftBlock.STATE, instructionIndex + 1), class_2248.field_31036);
    }

    public Instruction getInstruction(int instructionIndex) {
        return instructionIndex >= 0 && instructionIndex < instructions.size() ? instructions.get(instructionIndex) : null;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("InstructionIndex", currentInstruction);
        view.method_71465("InstructionDuration", currentInstructionDuration);
        view.method_71464("InstructionProgress", currentInstructionProgress);
        view.method_71465("Timer", timer);
        view.method_71472("PrevPowered", poweredPreviously);
        if (!instructions.isEmpty()) {
            class_11372.class_11373<Instruction> list = view.method_71467("Instructions", Instruction.CODEC);
            instructions.forEach(list::method_71484);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        currentInstruction = view.method_71424("InstructionIndex", 0);
        currentInstructionDuration = view.method_71424("InstructionDuration", 0);
        currentInstructionProgress = view.method_71423("InstructionProgress", 0);
        poweredPreviously = view.method_71433("PrevPowered", false);
        timer = view.method_71424("Timer", 0);
        view.method_71435("Instructions", Instruction.CODEC).ifPresentOrElse(
            list -> {
                instructions = new Vector<>(5);
                list.forEach(instructions::add);
            }, () -> instructions = Instruction.createDefault()
        );
        super.read(view, clientPacket);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        //TODO
        //        computerBehaviour.removePeripheral();
    }

    @Override
    public float getRotationSpeedModifier(class_2350 face) {
        if (isVirtual())
            return 1;
        return (!hasSource() || face == getSourceFacing()) ? 1 : getModifier();
    }

    public int getModifier() {
        if (currentInstruction >= instructions.size())
            return 0;
        return isIdle() ? 0 : instructions.get(currentInstruction).getSpeedModifier();
    }

    public Vector<Instruction> getInstructions() {
        return this.instructions;
    }

}