package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class KineticSpeedDisplaySource extends NumericSingleLineDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        if (!(context.getSourceBlockEntity() instanceof SpeedGaugeBlockEntity speedGauge))
            return ZERO.method_27661();

        boolean absoluteValue = context.sourceConfig().method_68083("Directional", 0) == 0;
        float speed = absoluteValue ? Math.abs(speedGauge.getSpeed()) : speedGauge.getSpeed();
        if (class_3532.method_15347(speed, 0)) {
            speed = 0;
        }
        return class_2561.method_43470(format.format(speed).replace("\u00A0", " ")).method_10852(class_2561.method_43470(" "))
            .method_10852(class_2561.method_43471("create.generic.unit.rpm"));
    }

    @Override
    protected String getTranslationKey() {
        return "kinetic_speed";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}