package com.zurrtum.create.content.redstone.displayLink.target;

import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class DisplayBoardTarget extends DisplayTarget {

    @Override
    public void acceptText(int line, List<class_5250> text, DisplayLinkContext context) {
    }

    public void acceptFlapText(int line, List<List<class_5250>> text, DisplayLinkContext context) {
        FlapDisplayBlockEntity controller = getController(context);
        if (controller == null)
            return;
        if (!controller.isSpeedRequirementFulfilled())
            return;

        DisplaySource source = context.blockEntity().activeSource;
        List<FlapDisplayLayout> lines = controller.getLines();
        for (int i = 0; i + line < lines.size(); i++) {

            if (i == 0)
                reserve(i + line, controller, context);
            if (i > 0 && isReserved(i + line, controller, context))
                break;

            FlapDisplayLayout layout = lines.get(i + line);

            if (i >= text.size()) {
                if (source instanceof SingleLineDisplaySource)
                    break;
                controller.applyTextManually(i + line, null);
                continue;
            }

            source.loadFlapDisplayLayout(context, controller, layout, i);

            for (int sectionIndex = 0; sectionIndex < layout.getSections().size(); sectionIndex++) {
                List<class_5250> textLine = text.get(i);
                if (textLine.size() <= sectionIndex)
                    break;
                layout.getSections().get(sectionIndex).setText(textLine.get(sectionIndex));
            }
        }

        controller.sendData();
    }

    @Override
    public boolean isReserved(int line, DisplayHolder target, DisplayLinkContext context) {
        return super.isReserved(
            line,
            target,
            context
        ) || target instanceof FlapDisplayBlockEntity fdte && fdte.manualLines.length > line && fdte.manualLines[line];
    }

    @Override
    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        FlapDisplayBlockEntity controller = getController(context);
        if (controller == null)
            return new DisplayTargetStats(1, 1, this);
        return new DisplayTargetStats(controller.ySize * 2, controller.getMaxCharCount(), this);
    }

    private FlapDisplayBlockEntity getController(DisplayLinkContext context) {
        class_2586 teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof FlapDisplayBlockEntity be))
            return null;
        return be.getController();
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_238 baseShape = super.getMultiblockBounds(level, pos);
        class_2586 be = level.method_8321(pos);

        if (!(be instanceof FlapDisplayBlockEntity fdbe))
            return baseShape;

        FlapDisplayBlockEntity controller = fdbe.getController();
        if (controller == null)
            return baseShape;

        class_2382 normal = controller.getDirection().method_10170().method_62675();
        return baseShape.method_996(controller.method_11016().method_10059(pos))
            .method_1012(normal.method_10263() * (controller.xSize - 1), 1 - controller.ySize, normal.method_10260() * (controller.xSize - 1));
    }
}