package com.zurrtum.create.content.trains.schedule.destination;

import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime.State;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ChangeThrottleInstruction extends ScheduleInstruction {
    public ChangeThrottleInstruction(class_2960 id) {
        super(id);
        data.method_10569("Value", 100);
    }

    @Override
    public boolean supportsConditions() {
        return false;
    }

    public float getThrottle() {
        return intData("Value") / 100f;
    }

    @Override
    public @Nullable DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        runtime.train.throttle = getThrottle();
        runtime.state = State.PRE_TRANSIT;
        runtime.currentEntry++;
        return null;
    }
}
