package com.zurrtum.create.content.trains.track;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.IMergeableBE;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5321;

public class TrackBlockEntity extends SmartBlockEntity implements TransformableBlockEntity, IMergeableBE {

    Map<class_2338, BezierConnection> connections;
    boolean cancelDrops;

    public Pair<class_5321<class_1937>, class_2338> boundLocation;
    public TrackBlockEntityTilt tilt;

    public TrackBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK, pos, state);
        connections = new HashMap<>();
        setLazyTickRate(100);
        tilt = new TrackBlockEntityTilt(this);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        cancelDrops |= field_11863.method_8320(pos).method_27852(AllBlocks.TRACK);
        removeInboundConnections(true);
    }

    public Map<class_2338, BezierConnection> getConnections() {
        return connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (field_11863.field_9236 && hasInteractableConnections())
            AllClientHandle.INSTANCE.registerToCurveInteraction(this);
    }

    @Override
    public void tick() {
        super.tick();
        tilt.undoSmoothing();
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : connections.values())
            if (connection.isPrimary())
                manageFakeTracksAlong(connection, false);
    }

    public void validateConnections() {
        Set<class_2338> invalid = new HashSet<>();

        for (Map.Entry<class_2338, BezierConnection> entry : connections.entrySet()) {
            class_2338 key = entry.getKey();
            BezierConnection bc = entry.getValue();

            if (!key.equals(bc.getKey()) || !field_11867.equals(bc.bePositions.getFirst())) {
                invalid.add(key);
                continue;
            }

            class_2680 blockState = field_11863.method_8320(key);
            if (blockState.method_26204() instanceof ITrackBlock trackBlock && !blockState.method_11654(TrackBlock.HAS_BE))
                for (class_243 v : trackBlock.getTrackAxes(field_11863, key, blockState)) {
                    class_243 bcEndAxis = bc.axes.getSecond();
                    if (v.method_1022(bcEndAxis) < 1 / 1024f || v.method_1022(bcEndAxis.method_1021(-1)) < 1 / 1024f)
                        field_11863.method_8652(key, blockState.method_11657(TrackBlock.HAS_BE, true), class_2248.field_31036);
                }

            class_2586 blockEntity = field_11863.method_8321(key);
            if (!(blockEntity instanceof TrackBlockEntity trackBE) || blockEntity.method_11015()) {
                invalid.add(key);
                continue;
            }

            if (!trackBE.connections.containsKey(field_11867)) {
                trackBE.addConnection(bc.secondary());
                trackBE.tilt.tryApplySmoothing();
            }
        }

        for (class_2338 blockPos : invalid)
            removeConnection(blockPos);
    }

    public void addConnection(BezierConnection connection) {
        // don't replace existing connections with different materials
        if (connections.containsKey(connection.getKey()) && connection.equalsSansMaterial(connections.get(connection.getKey())))
            return;
        connections.put(connection.getKey(), connection);
        field_11863.method_64310(field_11867, method_11010().method_26204(), 1);
        notifyUpdate();

        if (connection.isPrimary())
            manageFakeTracksAlong(connection, false);
    }

    public void removeConnection(class_2338 target) {
        if (isTilted())
            tilt.captureSmoothingHandles();

        BezierConnection removed = connections.remove(target);
        notifyUpdate();

        if (removed != null)
            manageFakeTracksAlong(removed, true);

        if (!connections.isEmpty() || method_11010().method_61767(TrackBlock.SHAPE, TrackShape.NONE).isPortal())
            return;

        class_2680 blockState = field_11863.method_8320(field_11867);
        if (blockState.method_28498(TrackBlock.HAS_BE))
            field_11863.method_8501(field_11867, blockState.method_11657(TrackBlock.HAS_BE, false));
        if (field_11863 instanceof class_3218 serverLevel) {
            class_2596<?> packet = new RemoveBlockEntityPacket(field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    public void removeInboundConnections(boolean dropAndDiscard) {
        for (BezierConnection bezierConnection : connections.values()) {
            if (!(field_11863.method_8321(bezierConnection.getKey()) instanceof TrackBlockEntity tbe))
                return;
            tbe.removeConnection(bezierConnection.bePositions.getFirst());
            if (!dropAndDiscard)
                continue;
            if (!cancelDrops)
                bezierConnection.spawnItems(field_11863);
            bezierConnection.spawnDestroyParticles(field_11863);
        }
        if (dropAndDiscard && field_11863 instanceof class_3218 serverLevel) {
            class_2596<?> packet = new RemoveBlockEntityPacket(field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    public void bind(class_5321<class_1937> boundDimension, class_2338 boundLocation) {
        this.boundLocation = Pair.of(boundDimension, boundLocation);
        method_5431();
    }

    public boolean isTilted() {
        return tilt.smoothingAngle.isPresent();
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        writeTurns(view, true);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        writeTurns(view, false);
        tilt.smoothingAngle.ifPresent(angle -> view.method_71468("Smoothing", Codec.DOUBLE, angle));
        if (boundLocation == null)
            return;
        view.method_71468("BoundLocation", class_2338.field_25064, boundLocation.getSecond());
        view.method_71468("BoundDimension", class_1937.field_25178, boundLocation.getFirst());
    }

    private void writeTurns(class_11372 view, boolean restored) {
        class_11372.class_11374 list = view.method_71476("Connections");
        for (BezierConnection bezierConnection : connections.values())
            (restored ? tilt.restoreToOriginalCurve(bezierConnection.clone()) : bezierConnection).write(list.method_71480(), field_11867);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        connections.clear();
        view.method_71438("Connections").forEach(item -> {
            BezierConnection connection = new BezierConnection(item, field_11867);
            connections.put(connection.getKey(), connection);
        });

        boolean smoothingPreviously = tilt.smoothingAngle.isPresent();
        tilt.smoothingAngle = view.method_71426("Smoothing", Codec.DOUBLE);
        if (smoothingPreviously != tilt.smoothingAngle.isPresent() && clientPacket) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), 16);
        }

        if (field_11863 != null && field_11863.field_9236) {
            AllClientHandle.INSTANCE.queueUpdate(this);

            if (hasInteractableConnections())
                AllClientHandle.INSTANCE.registerToCurveInteraction(this);
            else
                AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
        }

        view.method_71426("BoundLocation", class_2338.field_25064)
            .ifPresent(pos -> boundLocation = Pair.of(view.method_71426("BoundDimension", class_1937.field_25178).orElseThrow(), pos));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void accept(class_2586 other) {
        if (other instanceof TrackBlockEntity track)
            connections.putAll(track.connections);
        validateConnections();
        field_11863.method_64310(field_11867, method_11010().method_26204(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : connections.values())
            if (connection.isPrimary())
                return true;
        return false;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        Map<class_2338, BezierConnection> restoredConnections = new HashMap<>();
        for (Map.Entry<class_2338, BezierConnection> entry : connections.entrySet())
            restoredConnections.put(
                entry.getKey(),
                tilt.restoreToOriginalCurve(tilt.restoreToOriginalCurve(entry.getValue().secondary()).secondary())
            );
        connections = restoredConnections;
        tilt.smoothingAngle = Optional.empty();

        if (transform.rotationAxis != class_2351.field_11052)
            return;

        Map<class_2338, BezierConnection> transformedConnections = new HashMap<>();
        for (Map.Entry<class_2338, BezierConnection> entry : connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);

            class_2338 diff = newConnection.bePositions.getSecond().method_10059(newConnection.bePositions.getFirst());
            newConnection.bePositions.setSecond(class_2338.method_49638(class_243.method_24953(newConnection.bePositions.getFirst())
                .method_1019(transform.applyWithoutOffsetUncentered(class_243.method_24954(diff)))));

            class_243 beVec = class_243.method_24954(field_11867);
            class_243 teCenterVec = beVec.method_1031(0.5, 0.5, 0.5);
            class_243 start = newConnection.starts.getFirst();
            class_243 startToBE = start.method_1020(teCenterVec);
            class_243 endToStart = newConnection.starts.getSecond().method_1020(start);
            startToBE = transform.applyWithoutOffsetUncentered(startToBE).method_1019(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).method_1019(startToBE);

            newConnection.starts.setFirst(new TrackNodeLocation(startToBE).getLocation());
            newConnection.starts.setSecond(new TrackNodeLocation(endToStart).getLocation());

            class_2338 newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }

        connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (field_11863.field_9236)
            AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
    }

    @Override
    public void remove() {
        super.remove();

        for (BezierConnection connection : connections.values())
            manageFakeTracksAlong(connection, true);

        if (boundLocation != null && field_11863 instanceof class_3218) {
            class_3218 otherLevel = field_11863.method_8503().method_3847(boundLocation.getFirst());
            if (otherLevel == null)
                return;
            if (otherLevel.method_8320(boundLocation.getSecond()).method_26164(AllBlockTags.TRACKS))
                otherLevel.method_22352(boundLocation.getSecond(), false);
        }
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        Map<Pair<Integer, Integer>, Double> yLevels = bc.rasterise();

        for (Map.Entry<Pair<Integer, Integer>, Double> entry : yLevels.entrySet()) {
            double yValue = entry.getValue();
            int floor = class_3532.method_15357(yValue);
            class_2338 targetPos = new class_2338(entry.getKey().getFirst(), floor, entry.getKey().getSecond());
            targetPos = targetPos.method_10081(bc.bePositions.getFirst()).method_10086(1);

            class_2680 stateAtPos = field_11863.method_8320(targetPos);
            boolean present = stateAtPos.method_27852(AllBlocks.FAKE_TRACK);

            if (remove) {
                if (present)
                    field_11863.method_8650(targetPos, false);
                continue;
            }

            class_3610 fluidState = stateAtPos.method_26227();
            if (!fluidState.method_15769() && !fluidState.method_33659(class_3612.field_15910))
                continue;

            if (!present && stateAtPos.method_45474())
                field_11863.method_8652(
                    targetPos,
                    ProperWaterloggedBlock.withWater(field_11863, AllBlocks.FAKE_TRACK.method_9564(), targetPos),
                    class_2248.field_31036
                );
            FakeTrackBlock.keepAlive(field_11863, targetPos);
        }
    }

}
