package com.zurrtum.create.foundation.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.Create;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.minecraft.class_3218;
import net.minecraft.class_4013;
import net.minecraft.class_8786;

/**
 * Utility for searching through a level's recipe collection.
 * Non-dynamic conditions can be split off into an initial search for caching intermediate results.
 *
 * @author simibubi
 */
public class RecipeFinder {
    private static final Cache<Object, List<class_8786<?>>> CACHED_SEARCHES = CacheBuilder.newBuilder().build();

    public static final class_4013 LISTENER = resourceManager -> CACHED_SEARCHES.invalidateAll();

    /**
     * Find all recipes matching the condition predicate.
     * If this search is made more than once,
     * using the same object instance as the cacheKey will retrieve the cached result from the first search.
     *
     * @param cacheKey (can be null to prevent the caching)
     * @return A started search to continue with more specific conditions.
     */
    public static List<class_8786<?>> get(@Nullable Object cacheKey, class_3218 level, Predicate<class_8786<?>> conditions) {
        if (cacheKey == null)
            return startSearch(level, conditions);

        try {
            return CACHED_SEARCHES.get(cacheKey, () -> startSearch(level, conditions));
        } catch (ExecutionException e) {
            Create.LOGGER.error("Encountered a exception while searching for recipes", e);
        }

        return Collections.emptyList();
    }

    private static List<class_8786<?>> startSearch(class_3218 level, Predicate<? super class_8786<?>> conditions) {
        List<class_8786<?>> recipes = new ArrayList<>();
        for (class_8786<?> r : level.method_64577().method_8126())
            if (conditions.test(r))
                recipes.add(r);
        return recipes;
    }
}