package com.zurrtum.create.impl.effect;

import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3922;
import net.minecraft.class_5540;
import net.minecraft.class_6088;

public class WaterEffectHandler implements OpenPipeEffectHandler {
    @Override
    public void apply(class_1937 level, class_238 area, FluidStack fluid) {
        if (level.method_8510() % 5 != 0)
            return;

        List<class_1297> entities = level.method_8333(null, area, class_1297::method_5809);
        for (class_1297 entity : entities)
            entity.method_5646();

        class_2338.method_29715(area).forEach(pos -> dowseFire(level, pos));
    }

    // Adapted from ThrownPotion
    private static void dowseFire(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26164(class_3481.field_21952)) {
            level.method_8650(pos, false);
        } else if (class_5540.method_35245(state)) {
            class_5540.method_31614(null, state, level, pos);
        } else if (class_3922.method_23896(state)) {
            level.method_8444(null, class_6088.field_31167, pos, 0);
            class_3922.method_29288(null, level, pos, state);
            level.method_8501(pos, state.method_11657(class_3922.field_17352, false));
        }
    }
}
