package com.zurrtum.create.impl.unpacking;

import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler.ConnectedInput;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity.CrafterItemHandler;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class CrafterUnpackingHandler implements UnpackingHandler {
    @Override
    public boolean unpack(
        class_1937 level,
        class_2338 pos,
        class_2680 state,
        class_2350 side,
        List<class_1799> items,
        @Nullable PackageOrderWithCrafts orderContext,
        boolean simulate
    ) {
        if (!PackageOrderWithCrafts.hasCraftingInformation(orderContext))
            return AllUnpackingHandlers.DEFAULT.unpack(level, pos, state, side, items, null, simulate);

        // Get item placement
        List<BigItemStack> craftingContext = orderContext.getCraftingInformation();

        class_2586 be = level.method_8321(pos);
        if (!(be instanceof MechanicalCrafterBlockEntity crafter))
            return false;

        ConnectedInput input = crafter.getInput();
        CrafterItemHandler[] inventories = input.getInventories(level, pos);
        int size = inventories.length;
        if (size == 0)
            return false;

        // insert in the order's defined ordering
        int max = Math.min(size, craftingContext.size());
        outer:
        for (int i = 0; i < max; i++) {
            BigItemStack targetStack = craftingContext.get(i);
            if (targetStack.stack.method_7960())
                continue;

            CrafterItemHandler inventory = inventories[i];
            // if there's already an item here, no point in trying
            if (!inventory.getStack().method_7960())
                continue;

            // go through each item in the box and try insert if it matches the target
            for (class_1799 stack : items) {
                if (class_1799.method_31577(stack, targetStack.stack)) {
                    int insert;
                    if (simulate) {
                        insert = inventory.countSpace(stack, 1);
                    } else {
                        insert = inventory.insert(stack, 1);
                    }
                    if (insert == 1) {
                        stack.method_7934(1);
                        // one item per crafter, move to next once successful
                        continue outer;
                    }
                }
            }
        }

        // if anything is still non-empty insertion failed
        for (class_1799 item : items) {
            if (!item.method_7960()) {
                return false;
            }
        }

        if (!simulate) {
            crafter.checkCompletedRecipe(true);
        }

        return true;
    }
}
