package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrieFinder;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.class_2170;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_5350;
import net.minecraft.class_7699;
import net.minecraft.class_9383;

@Mixin(class_5350.class)
public class DataPackContentsMixin {
    @ModifyReturnValue(method = "getContents()Ljava/util/List;", at = @At("RETURN"))
    private List<class_3302> add(List<class_3302> original) {
        List<class_3302> list = new ArrayList<>(original);
        list.add(RecipeFinder.LISTENER);
        list.add(RecipeTrieFinder.LISTENER);
        list.add(BeltHelper.LISTENER);
        list.add(AllConfigs.LISTENER);
        return Collections.unmodifiableList(list);
    }

    @Inject(method = "method_58296(Lnet/minecraft/resource/featuretoggle/FeatureSet;Lnet/minecraft/server/command/CommandManager$RegistrationEnvironment;Ljava/util/List;ILnet/minecraft/resource/ResourceManager;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Lnet/minecraft/registry/ReloadableRegistries$ReloadResult;)Ljava/util/concurrent/CompletionStage;", at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/SimpleResourceReload;start(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/resource/ResourceReload;"))
    private static void onReload(
        class_7699 featureSet,
        class_2170.class_5364 registrationEnvironment,
        List<?> list,
        int i,
        class_3300 resourceManager,
        Executor executor,
        Executor executor2,
        class_9383.class_9842 reloadResult,
        CallbackInfoReturnable<CompletionStage<class_5350>> cir
    ) {
        PotionRecipe.data = new PotionRecipe.ReloadData(reloadResult.comp_2899(), featureSet);
    }
}
