/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_897;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends AbstractContraptionState>
extends class_897<C, S> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_11515 renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, Pair.of((Object)contraption, (Object)renderType), () -> ContraptionEntityRenderer.buildStructureBuffer(clientContraption, renderWorld, renderType));
    }

    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption out = (ClientContraption)clientContraption.getAcquire();
        if (out == null) {
            clientContraption.compareAndExchangeRelease(null, this.createClientContraption(contraption));
            out = (ClientContraption)clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    private static SuperByteBuffer buildStructureBuffer(ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_11515 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = dispatcher.method_3349(state);
            long randomSeed = state.method_26190(pos);
            random.method_43052(randomSeed);
            if (class_4696.method_23679((class_2680)state) != layer) continue;
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            ObjectArrayList parts = new ObjectArrayList();
            class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
            if (class_10872 instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
                wrapper.addPartsWithInfo((class_1920)renderWorld, pos, state, random, (List<class_10889>)parts);
            } else {
                model.method_68513(random, (List)parts);
            }
            renderer.method_3374((class_1920)renderWorld, (List)parts, state, pos, poseStack, (class_4588)sbbBuilder, true, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        return sbbBuilder.end();
    }

    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public S createRenderState() {
        return (S)((Object)new AbstractContraptionState());
    }

    public void render(S state, class_4587 poseStack, class_4597 buffers, int overlay) {
        if (((AbstractContraptionState)((Object)state)).contraption == null) {
            return;
        }
        ClientContraption clientContraption = ((AbstractContraptionState)((Object)state)).contraption;
        Contraption contraption = clientContraption.getContraption();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        ContraptionMatrices matrices = clientContraption.getMatrices();
        matrices.setup((matrixStack, partialTicks) -> this.transform(state, (class_4587)matrixStack, partialTicks.floatValue()), poseStack, (AbstractContraptionState)((Object)state));
        if (!VisualizationManager.supportsVisualization((class_1936)((AbstractContraptionState)((Object)state)).world)) {
            for (class_11515 renderType : class_11515.values()) {
                SuperByteBuffer sbb = ContraptionEntityRenderer.getBuffer(contraption, clientContraption, renderWorld, renderType);
                if (sbb.isEmpty()) continue;
                class_4588 vc = buffers.getBuffer(this.getRenderLayer(renderType));
                ((SuperByteBuffer)sbb.transform(matrices.getModel())).useLevelLight((class_1920)((AbstractContraptionState)((Object)state)).world, matrices.getWorld()).renderInto(poseStack, vc);
            }
        }
        BitSet adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(clientContraption.renderedBlockEntityView, adjustRenderedBlockEntities, clientContraption.scratchErroredBlockEntities, renderWorld, ((AbstractContraptionState)((Object)state)).world, matrices.getModelViewProjection(), matrices.getLight(), buffers, AnimationTickHolder.getPartialTicks());
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        ContraptionEntityRenderer.renderActors(((AbstractContraptionState)((Object)state)).world, renderWorld, contraption, matrices, buffers);
        matrices.clear();
    }

    private class_1921 getRenderLayer(class_11515 layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case class_11515.field_60923 -> class_1921.method_23577();
            case class_11515.field_60924 -> class_1921.method_23579();
            case class_11515.field_60925 -> class_1921.method_23581();
            case class_11515.field_60926 -> PonderRenderTypes.translucent();
            case class_11515.field_60927 -> class_1921.method_29997();
        };
    }

    public void transform(S state, class_4587 matrixStack, float partialTicks) {
    }

    public void updateRenderState(C entity, S state, float tickProgress) {
        ((AbstractContraptionState)((Object)state)).world = entity.method_37908();
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        ((AbstractContraptionState)((Object)state)).contraption = contraption != null ? this.getOrCreateClientContraptionLazy(contraption) : null;
        ((AbstractContraptionState)((Object)state)).lastRenderX = ((AbstractContraptionEntity)((Object)entity)).field_6038;
        ((AbstractContraptionState)((Object)state)).lastRenderY = ((AbstractContraptionEntity)((Object)entity)).field_5971;
        ((AbstractContraptionState)((Object)state)).lastRenderZ = ((AbstractContraptionEntity)((Object)entity)).field_5989;
        ((AbstractContraptionState)((Object)state)).entityX = entity.method_23317();
        ((AbstractContraptionState)((Object)state)).entityY = entity.method_23318();
        ((AbstractContraptionState)((Object)state)).entityZ = entity.method_23321();
    }

    private static void renderActors(class_1937 level, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, class_4597 buffer) {
        class_4587 m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            MovementRenderBehaviour render;
            class_3499.class_3501 blockInfo;
            MovementBehaviour movementBehaviour;
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = level;
            }
            if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)(blockInfo = (class_3499.class_3501)pair.getLeft()).comp_1342())) == null || (render = (MovementRenderBehaviour)movementBehaviour.getAttachRender()) == null || c.isHiddenInPortal(blockInfo.comp_1341())) continue;
            m.method_22903();
            TransformStack.of(m).translate((class_2382)blockInfo.comp_1341());
            render.renderInContraption(context, renderWorld, matrices, buffer);
            m.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AbstractContraptionState
    extends class_10017 {
        public class_1937 world;
        public ClientContraption contraption;
        public double lastRenderX;
        public double lastRenderY;
        public double lastRenderZ;
        public double entityX;
        public double entityY;
        public double entityZ;
    }
}

