/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.wrench;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.render.DirectionIndicatorRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderer;
import com.zurrtum.create.client.content.contraptions.wrench.NonVisualizationLevel;
import com.zurrtum.create.client.content.contraptions.wrench.RadialWrenchHandler;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.infrastructure.packet.c2s.RadialWrenchMenuSubmitPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11244;
import net.minecraft.class_11256;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class RadialWrenchMenu
extends AbstractSimiScreen {
    public static final Map<class_2769<?>, String> VALID_PROPERTIES = new HashMap();
    public static final Set<class_2960> BLOCK_BLACKLIST;
    private final class_2680 state;
    private final class_2338 pos;
    private final class_2586 blockEntity;
    private final class_1937 level;
    private final NonVisualizationLevel nonVisualizationLevel;
    private final List<Map.Entry<class_2769<?>, String>> propertiesForState;
    private final int innerRadius = 50;
    private final int outerRadius = 110;
    private int selectedPropertyIndex = 0;
    private List<class_2680> allStates = List.of();
    private String propertyLabel = "";
    private int ticksOpen;
    private int selectedStateIndex = 0;
    private final RenderElement iconScroll = RenderElement.of(PonderGuiTextures.ICON_SCROLL);
    private final RenderElement iconUp = RenderElement.of(AllIcons.I_PRIORITY_HIGH);
    private final RenderElement iconDown = RenderElement.of(AllIcons.I_PRIORITY_LOW);

    public static void registerRotationProperty(class_2769<?> property, String label) {
        if (VALID_PROPERTIES.containsKey(property)) {
            return;
        }
        VALID_PROPERTIES.put(property, label);
    }

    public static void registerBlacklistedBlock(class_2960 location) {
        if (BLOCK_BLACKLIST.contains(location)) {
            return;
        }
        BLOCK_BLACKLIST.add(location);
    }

    public static Optional<RadialWrenchMenu> tryCreateFor(class_2680 state, class_2338 pos, class_1937 level) {
        if (BLOCK_BLACKLIST.contains(class_7923.field_41175.method_10221((Object)state.method_26204()))) {
            return Optional.empty();
        }
        List<Map.Entry<class_2769<?>, String>> propertiesForState = VALID_PROPERTIES.entrySet().stream().filter(entry -> state.method_28498((class_2769)entry.getKey())).toList();
        if (propertiesForState.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RadialWrenchMenu(state, pos, level, propertiesForState));
    }

    private RadialWrenchMenu(class_2680 state, class_2338 pos, class_1937 level, List<Map.Entry<class_2769<?>, String>> properties) {
        this.state = state;
        this.pos = pos;
        this.level = level;
        this.nonVisualizationLevel = new NonVisualizationLevel(level);
        this.blockEntity = level.method_8321(pos);
        this.propertiesForState = properties;
        this.initForSelectedProperty();
    }

    private void initForSelectedProperty() {
        Map.Entry<class_2769<?>, String> entry = this.propertiesForState.get(this.selectedPropertyIndex);
        this.allStates = new ArrayList<class_2680>();
        this.cycleAllPropertyValues(this.state, entry.getKey(), this.allStates);
        this.propertyLabel = entry.getValue();
    }

    private void cycleAllPropertyValues(class_2680 state, class_2769<?> property, List<class_2680> states) {
        Optional first = property.method_11898().stream().findFirst();
        if (first.isEmpty()) {
            return;
        }
        int offset = 0;
        int safety = 100;
        while (safety-- > 0) {
            if (state.method_11654(property).equals(first.get())) {
                offset = 99 - safety;
                break;
            }
            state = (class_2680)state.method_28493(property);
        }
        safety = 100;
        while (safety-- > 0 && !states.contains(state)) {
            states.add(state);
            state = (class_2680)state.method_28493(property);
        }
        this.selectedStateIndex = (offset = class_3532.method_15340((int)offset, (int)0, (int)(states.size() - 1))) == 0 ? 0 : states.size() - offset;
    }

    @Override
    public void method_25393() {
        ++this.ticksOpen;
        if (this.field_22787 != null && !this.level.method_8320(this.pos).method_27852(this.state.method_26204())) {
            this.field_22787.method_1507(null);
        }
        super.method_25393();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate((float)x, (float)y);
        int mouseOffsetX = mouseX - this.field_22789 / 2;
        int mouseOffsetY = mouseY - this.field_22790 / 2;
        if (class_3532.method_61344((float)mouseOffsetX, (float)mouseOffsetY) > 45.0f) {
            double theta = class_3532.method_15349((double)mouseOffsetX, (double)mouseOffsetY);
            float sectorSize = 360.0f / (float)this.allStates.size();
            this.selectedStateIndex = (int)Math.floor((-AngleHelper.deg(class_3532.method_15349((double)mouseOffsetX, (double)mouseOffsetY)) + 180.0f + sectorSize / 2.0f) % 360.0f / sectorSize);
            this.renderDirectionIndicator(graphics, theta);
        }
        this.renderRadialSectors(graphics);
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));
        if (this.selectedPropertyIndex > 0) {
            this.iconScroll.at(-14.0f, -46.0f).render(graphics);
            this.iconUp.at(-1.0f, -46.0f).render(graphics);
            graphics.method_25300(this.field_22793, this.propertiesForState.get(this.selectedPropertyIndex - 1).getValue(), 0, -30, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        if (this.selectedPropertyIndex < this.propertiesForState.size() - 1) {
            this.iconScroll.at(-14.0f, 30.0f).render(graphics);
            this.iconDown.at(-1.0f, 30.0f).render(graphics);
            graphics.method_25300(this.field_22793, this.propertiesForState.get(this.selectedPropertyIndex + 1).getValue(), 0, 22, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        graphics.method_25300(this.field_22793, "Currently", 0, -13, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, "Changing:", 0, -3, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, this.propertyLabel, 0, 7, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        ms.popMatrix();
    }

    private void renderRadialSectors(class_332 graphics) {
        int sectors = this.allStates.size();
        if (sectors < 2) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.method_51448();
        class_746 player = this.field_22787.field_1724;
        if (player == null) {
            return;
        }
        float sectorAngle = 360.0f / (float)sectors;
        int sectorWidth = 60;
        poseStack.pushMatrix();
        for (int i = 0; i < sectors; ++i) {
            Color innerColor = Color.WHITE.setAlpha(0.05f);
            Color outerColor = Color.WHITE.setAlpha(0.3f);
            class_2680 blockState = this.allStates.get(i);
            class_2769<?> property = this.propertiesForState.get(this.selectedPropertyIndex).getKey();
            poseStack.pushMatrix();
            if (i == this.selectedStateIndex) {
                innerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.2f), 0.5f);
                outerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.6f), 0.5f);
                UIRenderHelper.drawRadialSector(graphics, 112.0f, 113.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, outerColor, outerColor);
            }
            UIRenderHelper.drawRadialSector(graphics, 50.0f, 110.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, innerColor, outerColor);
            Color c = innerColor.copy().setAlpha(0.5f);
            UIRenderHelper.drawRadialSector(graphics, 47.0f, 48.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, c, c);
            poseStack.translate(0.0f, -((float)sectorWidth / 2.0f + 50.0f));
            poseStack.rotate((float)Math.PI / 180 * ((float)(-i) * sectorAngle));
            graphics.field_59826.method_70922((class_11256)EntityBlockRenderState.create(i, graphics, this.nonVisualizationLevel, this.pos, this.blockEntity, blockState, -21, -21, 1.5f, 17, player.method_36455(), player.method_36454() + 180.0f, 0.0f));
            if (i == this.selectedStateIndex) {
                graphics.method_25300(this.field_22793, blockState.method_11654(property).toString(), 0, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
            }
            poseStack.popMatrix();
            poseStack.pushMatrix();
            poseStack.rotate((float)Math.PI / 180 * sectorAngle / 2.0f);
            poseStack.translate(0.0f, -70.0f);
            UIRenderHelper.angledGradient(graphics, -90.0f, 0, 0, 0.5f, sectorWidth - 10, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            UIRenderHelper.angledGradient(graphics, 90.0f, 0, 0, 0.5f, 25.0f, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            poseStack.popMatrix();
            poseStack.rotate((float)Math.PI / 180 * sectorAngle);
        }
        poseStack.popMatrix();
    }

    private void renderDirectionIndicator(class_332 graphics, double theta) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.rotate((float)(-theta));
        poseStack.translate(0.0f, 53.0f);
        graphics.field_59826.method_70919((class_11244)new DirectionIndicatorRenderState(new Matrix3x2f((Matrix3x2fc)poseStack), 0.8f, 0.8f, 0.8f));
        poseStack.popMatrix();
    }

    private void submitChange() {
        class_2680 selectedState = this.allStates.get(this.selectedStateIndex);
        if (selectedState != this.state) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new RadialWrenchMenuSubmitPacket(this.pos, selectedState));
        }
        this.method_25419();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f));
        guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, color.getRGB(), color.getRGB());
    }

    public boolean method_16803(int code, int scanCode, int modifiers) {
        if (AllKeys.ROTATE_MENU.method_1417(code, scanCode)) {
            this.submitChange();
            return true;
        }
        return super.method_16803(code, scanCode, modifiers);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.submitChange();
            return true;
        }
        if (pButton == 1) {
            this.method_25419();
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.propertiesForState.size() < 2) {
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        int indexDelta = (int)Math.round(Math.signum(-scrollY));
        int newIndex = this.selectedPropertyIndex + indexDelta;
        if (newIndex < 0) {
            return false;
        }
        if (newIndex >= this.propertiesForState.size()) {
            return false;
        }
        this.selectedPropertyIndex = newIndex;
        this.initForSelectedProperty();
        return true;
    }

    public void method_25432() {
        RadialWrenchHandler.COOLDOWN = 2;
        int size = this.allStates.size();
        for (int i = 0; i < size; ++i) {
            EntityBlockRenderer.clear(i);
        }
        super.method_25432();
    }

    static {
        RadialWrenchMenu.registerRotationProperty(RotatedPillarKineticBlock.AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(DirectionalKineticBlock.FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(HorizontalKineticBlock.HORIZONTAL_FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(class_2377.field_11129, "Facing");
        RadialWrenchMenu.registerRotationProperty(DirectedDirectionalBlock.TARGET, "Target");
        RadialWrenchMenu.registerRotationProperty(SequencedGearshiftBlock.VERTICAL, "Vertical");
        BLOCK_BLACKLIST = new HashSet<class_2960>();
        RadialWrenchMenu.registerBlacklistedBlock(class_7923.field_41175.method_10221((Object)AllBlocks.LARGE_WATER_WHEEL));
        RadialWrenchMenu.registerBlacklistedBlock(class_7923.field_41175.method_10221((Object)AllBlocks.WATER_WHEEL_STRUCTURAL));
    }
}

