/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainRelocator;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.packet.c2s.TrainRelocationPacket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TrainRelocatorClient {
    static WeakReference<CarriageContraptionEntity> hoveredEntity = new WeakReference<Object>(null);
    static UUID relocatingTrain;
    static class_243 relocatingOrigin;
    static int relocatingEntityId;
    static class_2338 lastHoveredPos;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static Boolean lastHoveredResult;
    static List<class_243> toVisualise;

    public static boolean onClicked(class_310 mc) {
        Boolean relocate;
        if (relocatingTrain == null) {
            return false;
        }
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        if (!player.method_19538().method_24802((class_2374)relocatingOrigin, 24.0) || player.method_5715()) {
            relocatingTrain = null;
            player.method_7353((class_2561)CreateLang.translateDirect("train.relocate.abort", new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        if (player.method_5765()) {
            return false;
        }
        if (mc.field_1687 == null) {
            return false;
        }
        Train relocating = TrainRelocatorClient.getRelocating();
        if (relocating != null && (relocate = TrainRelocatorClient.relocateClient(mc, relocating, false)) != null) {
            if (relocate.booleanValue()) {
                relocatingTrain = null;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static Boolean relocateClient(class_310 mc, Train relocating, boolean simulate) {
        class_2680 blockState;
        TrackBlockOutline.BezierPointSelection bezierSelection;
        class_243 offset;
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3965)) {
            return null;
        }
        class_3965 blockhit = (class_3965)hitResult;
        class_2338 blockPos = blockhit.method_17777();
        BezierTrackPointLocation hoveredBezier = null;
        boolean upsideDown = relocating.carriages.getFirst().leadingBogey().isUpsideDown();
        class_243 class_2432 = offset = upsideDown ? new class_243(0.0, -0.5, 0.0) : class_243.field_1353;
        if (simulate && !toVisualise.isEmpty() && lastHoveredResult != null) {
            for (int i = 0; i < toVisualise.size() - 1; ++i) {
                class_243 vec1 = toVisualise.get(i).method_1019(offset);
                class_243 vec2 = toVisualise.get(i + 1).method_1019(offset);
                Outliner.getInstance().showLine(Pair.of(relocating, i), vec1.method_1031(0.0, (double)-0.925f, 0.0), vec2.method_1031(0.0, (double)-0.925f, 0.0)).colored(lastHoveredResult != false || i != toVisualise.size() - 2 ? 9817409 : 15359019).disableLineNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
            }
        }
        if ((bezierSelection = TrackBlockOutline.result) != null) {
            blockPos = bezierSelection.blockEntity().method_11016();
            hoveredBezier = bezierSelection.loc();
        }
        if (simulate) {
            if (lastHoveredPos != null && lastHoveredPos.equals((Object)blockPos) && Objects.equals(lastHoveredBezierSegment, hoveredBezier)) {
                return lastHoveredResult;
            }
            lastHoveredPos = blockPos;
            lastHoveredBezierSegment = hoveredBezier;
            toVisualise.clear();
        }
        if (!((blockState = mc.field_1687.method_8320(blockPos)).method_26204() instanceof ITrackBlock)) {
            lastHoveredResult = null;
            return null;
        }
        class_243 lookAngle = mc.field_1724.method_5720();
        boolean direction = bezierSelection != null && lookAngle.method_1026(bezierSelection.direction()) < 0.0;
        boolean result = TrainRelocator.relocate(relocating, (class_1937)mc.field_1687, blockPos, hoveredBezier, direction, lookAngle, toVisualise);
        if (!simulate && result) {
            relocating.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
            }));
            mc.field_1724.field_3944.method_52787((class_2596)new TrainRelocationPacket(relocatingTrain, blockPos, lookAngle, relocatingEntityId, direction, hoveredBezier));
        }
        lastHoveredResult = result;
        return lastHoveredResult;
    }

    public static void clientTick(class_310 mc) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (player.method_5765()) {
            return;
        }
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        if (relocatingTrain != null) {
            AbstractContraptionEntity ce;
            Train relocating = TrainRelocatorClient.getRelocating();
            if (relocating == null) {
                relocatingTrain = null;
                return;
            }
            class_1297 entity = world.method_8469(relocatingEntityId);
            if (entity instanceof AbstractContraptionEntity && Math.abs((ce = (AbstractContraptionEntity)entity).method_30950(0.0f).method_1020(ce.method_30950(1.0f)).method_1027()) > 9.765625E-4) {
                player.method_7353((class_2561)CreateLang.translateDirect("train.cannot_relocate_moving", new Object[0]).method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }
            if (!player.method_6047().method_31574((class_1792)AllItems.WRENCH)) {
                player.method_7353((class_2561)CreateLang.translateDirect("train.relocate.abort", new Object[0]).method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }
            if (!player.method_19538().method_24802((class_2374)relocatingOrigin, 24.0)) {
                player.method_7353((class_2561)CreateLang.translateDirect("train.relocate.too_far", new Object[0]).method_27692(class_124.field_1061), true);
                return;
            }
            Boolean success = TrainRelocatorClient.relocateClient(mc, relocating, true);
            if (success == null) {
                player.method_7353((class_2561)CreateLang.translateDirect("train.relocate", relocating.name), true);
            } else if (success.booleanValue()) {
                player.method_7353((class_2561)CreateLang.translateDirect("train.relocate.valid", new Object[0]).method_27692(class_124.field_1060), true);
            } else {
                player.method_7353((class_2561)CreateLang.translateDirect("train.relocate.invalid", new Object[0]).method_27692(class_124.field_1061), true);
            }
            return;
        }
        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        class_243 origin = (class_243)rayInputs.getFirst();
        class_243 target = (class_243)rayInputs.getSecond();
        CarriageContraptionEntity currentEntity = (CarriageContraptionEntity)((Object)hoveredEntity.get());
        if (currentEntity != null) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, currentEntity) != null) {
                return;
            }
            hoveredEntity = new WeakReference<Object>(null);
        }
        class_238 aabb = new class_238(origin, target);
        List intersectingContraptions = world.method_18467(CarriageContraptionEntity.class, aabb);
        for (CarriageContraptionEntity contraptionEntity : intersectingContraptions) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity) == null) continue;
            hoveredEntity = new WeakReference<CarriageContraptionEntity>(contraptionEntity);
        }
    }

    public static boolean carriageWrenched(class_243 vec3, CarriageContraptionEntity entity) {
        Train train = TrainRelocatorClient.getTrainFromEntity(entity);
        if (train == null) {
            return false;
        }
        relocatingOrigin = vec3;
        relocatingTrain = train.id;
        relocatingEntityId = entity.method_5628();
        return true;
    }

    public static boolean addToTooltip(List<class_2561> tooltip) {
        Train train = TrainRelocatorClient.getTrainFromEntity((CarriageContraptionEntity)((Object)hoveredEntity.get()));
        if (train != null && train.derailed) {
            TooltipHelper.addHint(tooltip, "hint.derailed_train", new Object[0]);
            return true;
        }
        return false;
    }

    private static Train getRelocating() {
        return relocatingTrain == null ? null : Create.RAILWAYS.trains.get(relocatingTrain);
    }

    private static Train getTrainFromEntity(CarriageContraptionEntity carriageContraptionEntity) {
        if (carriageContraptionEntity == null) {
            return null;
        }
        Carriage carriage = carriageContraptionEntity.getCarriage();
        if (carriage == null) {
            return null;
        }
        return carriage.train;
    }

    static {
        toVisualise = new ArrayList<class_243>();
    }
}

