/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.client.foundation.render.AllRenderPipelines;
import com.zurrtum.create.client.ponder.enums.PonderSpecialTextures;
import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

@Environment(value=EnvType.CLIENT)
public class CubeParticle
extends class_703 {
    private static final class_1921 LAYER = class_1921.method_24049((String)"create:cube", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)AllRenderPipelines.CUBE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(PonderSpecialTextures.BLANK.getLocation(), false)).method_23610(class_1921.field_25281).method_23608(class_1921.field_21383).method_23617(false));
    public static final class_243[] CUBE = new class_243[]{new class_243(1.0, 1.0, -1.0), new class_243(1.0, 1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(1.0, 1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, 1.0, -1.0), new class_243(1.0, -1.0, -1.0)};
    protected float scale;
    protected boolean hot;
    private boolean billowing = false;

    public CubeParticle(class_638 world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_3852 = motionX;
        this.field_3869 = motionY;
        this.field_3850 = motionZ;
        this.setScale(0.2f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.method_3080(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        this.field_3847 = (int)((double)age + (this.field_3840.method_43058() * 2.0 - 1.0) * 8.0);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public void method_3070() {
        if (this.hot && this.field_3866 > 0) {
            if (this.field_3838 == this.field_3854) {
                this.billowing = true;
                this.field_21507 = false;
                if (this.field_3852 == 0.0 && this.field_3850 == 0.0) {
                    class_243 diff = class_243.method_24954((class_2382)class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)).method_1031(0.5, 0.5, 0.5).method_1023(this.field_3874, this.field_3854, this.field_3871);
                    this.field_3852 = -diff.field_1352 * 0.1;
                    this.field_3850 = -diff.field_1350 * 0.1;
                }
                this.field_3852 *= 1.1;
                this.field_3869 *= 0.9;
                this.field_3850 *= 1.1;
            } else if (this.billowing) {
                this.field_3869 *= 1.2;
            }
        }
        super.method_3070();
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickProgress) {
    }

    public void method_65198(class_4587 matrices, class_4597 vertexConsumers, class_4184 renderInfo, float tickProgress) {
        class_4588 buffer = vertexConsumers.getBuffer(LAYER);
        class_243 projectedView = renderInfo.method_19326();
        float lerpedX = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3858, (double)this.field_3874) - projectedView.method_10216());
        float lerpedY = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3838, (double)this.field_3854) - projectedView.method_10214());
        float lerpedZ = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3856, (double)this.field_3871) - projectedView.method_10215());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(class_3532.method_15363((float)((float)this.field_3866 + tickProgress), (float)0.0f, (float)this.field_3847), 3.0) / Math.pow(this.field_3847, 3.0);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                class_243 vec = CUBE[i * 4 + j].method_1021(-1.0);
                vec = vec.method_1021((double)this.scale * ageMultiplier).method_1031((double)lerpedX, (double)lerpedY, (double)lerpedZ);
                buffer.method_22912((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350).method_22913((float)j / 2.0f, (float)(j % 2)).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
            }
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<CubeParticleData> {
        public class_703 createParticle(CubeParticleData data, class_638 world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            CubeParticle particle = new CubeParticle(world, x, y, z, motionX, motionY, motionZ);
            particle.method_3084(data.red(), data.green(), data.blue());
            particle.setScale(data.scale());
            particle.averageAge(data.avgAge());
            particle.setHot(data.hot());
            return particle;
        }
    }
}

