/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.PistonContraption;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class MechanicalPistonBlockEntity
extends LinearActuatorBlockEntity {
    protected int extensionLength;

    public MechanicalPistonBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_PISTON, pos, state);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.extensionLength = view.method_71424("ExtensionLength", 0);
        super.read(view, clientPacket);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("ExtensionLength", this.extensionLength);
        super.write(view, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof MechanicalPistonBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        PistonContraption contraption = new PistonContraption(direction, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.field_11863, this.field_11867)) {
            return;
        }
        class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)direction.method_10166());
        class_2350 movementDirection = this.getSpeed() > 0.0f ^ direction.method_10166() != class_2350.class_2351.field_11051 ? positive : positive.method_10153();
        class_2338 anchor = contraption.anchor.method_10079(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, anchor.method_10093(movementDirection), movementDirection)) {
            return;
        }
        this.extensionLength = contraption.extensionLength;
        float resultingOffset = (float)contraption.initialExtensionProgress + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress;
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        class_2338 startPos = class_2338.field_10980.method_10079(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(this.field_11863, startPos);
        this.movedContraption = ControlledContraptionEntity.create(this.method_10997(), this, contraption);
        this.resetContraptionToOffset();
        this.forceMove = true;
        this.field_11863.method_8649((class_1297)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.field_11865) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.EXTENDED)), 19);
        }
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.field_11865) {
            AllBlocks.MECHANICAL_PISTON.method_9576(this.field_11863, this.field_11867, this.method_11010(), null);
        }
    }

    @Override
    protected void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = class_3532.method_15363((float)MechanicalPistonBlockEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.field_11863.field_9236) {
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        }
        class_2350 pistonDirection = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        int movementModifier = pistonDirection.method_10171().method_10181() * (pistonDirection.method_10166() == class_2350.class_2351.field_11051 ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff / 2.0f;
        int extensionRange = this.getExtensionRange();
        movementSpeed = class_3532.method_15363((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)extensionRange - this.offset));
        if (this.sequencedOffsetLimit >= 0.0) {
            movementSpeed = (float)class_3532.method_15350((double)movementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return this.extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        class_2350 pistonDirection = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        return class_243.method_24954((class_2382)pistonDirection.method_62675()).method_1021((double)speed);
    }

    @Override
    protected class_243 toPosition(float offset) {
        class_243 position = class_243.method_24954((class_2382)((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525)).method_62675()).method_1021((double)offset);
        return position.method_1019(class_243.method_24954((class_2382)this.movedContraption.getContraption().anchor));
    }

    @Override
    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PistonContraption)this.movedContraption.getContraption()).initialExtensionProgress;
    }
}

