/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileBlockHitAction;
import com.zurrtum.create.api.registry.CreateRegistries;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class AllPotatoProjectileBlockHitActions {
    public static void register() {
        AllPotatoProjectileBlockHitActions.register("plant_crop", PlantCrop.CODEC);
        AllPotatoProjectileBlockHitActions.register("place_block_on_ground", PlaceBlockOnGround.CODEC);
    }

    private static void register(String name, MapCodec<? extends PotatoProjectileBlockHitAction> codec) {
        class_2378.method_10230(CreateRegistries.POTATO_PROJECTILE_BLOCK_HIT_ACTION, (class_2960)class_2960.method_60655((String)"create", (String)name), codec);
    }

    public record PlantCrop(class_6880<class_2248> cropBlock) implements PotatoProjectileBlockHitAction
    {
        public static final MapCodec<PlantCrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_40294().fieldOf("block").forGetter(PlantCrop::cropBlock)).apply((Applicative)instance, PlantCrop::new));

        public PlantCrop(class_2248 cropBlock) {
            this((class_6880<class_2248>)cropBlock.method_40142());
        }

        @Override
        public boolean execute(class_1936 level, class_1799 projectile, class_3965 ray) {
            class_1937 l;
            if (level.method_8608()) {
                return true;
            }
            class_2338 hitPos = ray.method_17777();
            if (level instanceof class_1937 && !(l = (class_1937)level).method_8477(hitPos)) {
                return true;
            }
            class_2350 face = ray.method_17780();
            if (face != class_2350.field_11036) {
                return false;
            }
            class_2338 placePos = hitPos.method_10093(face);
            return level.method_8320(placePos).method_45474();
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }

    public record PlaceBlockOnGround(class_6880<class_2248> block) implements PotatoProjectileBlockHitAction
    {
        public static final MapCodec<PlaceBlockOnGround> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_40294().fieldOf("block").forGetter(PlaceBlockOnGround::block)).apply((Applicative)instance, PlaceBlockOnGround::new));

        public PlaceBlockOnGround(class_2248 block) {
            this((class_6880<class_2248>)block.method_40142());
        }

        @Override
        public boolean execute(class_1936 levelAccessor, class_1799 projectile, class_3965 ray) {
            class_1937 l;
            if (levelAccessor.method_8608()) {
                return true;
            }
            class_2338 hitPos = ray.method_17777();
            if (levelAccessor instanceof class_1937 && !(l = (class_1937)levelAccessor).method_8477(hitPos)) {
                return true;
            }
            class_2350 face = ray.method_17780();
            class_2338 placePos = hitPos.method_10093(face);
            if (!levelAccessor.method_8320(placePos).method_45474()) {
                return false;
            }
            if (face == class_2350.field_11036) {
                levelAccessor.method_8652(placePos, ((class_2248)this.block.comp_349()).method_9564(), 3);
            } else if (levelAccessor instanceof class_1937) {
                class_1937 level = (class_1937)levelAccessor;
                double y = (double)ray.method_17777().method_10264() - 0.5;
                if (!level.method_22347(placePos.method_10084())) {
                    y = Math.min(y, (double)placePos.method_10264());
                }
                if (!level.method_22347(placePos.method_10074())) {
                    y = Math.max(y, (double)placePos.method_10264());
                }
                class_1540 falling = new class_1540(level, (double)placePos.method_10263() + 0.5, y, (double)placePos.method_10260() + 0.5, ((class_2248)this.block.comp_349()).method_9564());
                falling.field_7192 = 1;
                level.method_8649((class_1297)falling);
            }
            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }
}

