/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagerLink;

import com.google.common.cache.Cache;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_4208;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class LogisticallyLinkedBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<LogisticallyLinkedBehaviour> TYPE = new BehaviourType();
    public static final AtomicInteger LINK_ID_GENERATOR = new AtomicInteger();
    public int linkId;
    public int redstonePower;
    public UUID freqId;
    private boolean addedGlobally = false;
    private boolean loadedGlobally = false;
    private boolean global;
    private static final Cache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>> LINKS = new TickBasedCache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>>(20, true);
    private static final Cache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>> CLIENT_LINKS = new TickBasedCache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>>(20, true, true);

    public LogisticallyLinkedBehaviour(SmartBlockEntity be, boolean global) {
        super(be);
        this.global = global;
        this.linkId = LINK_ID_GENERATOR.getAndIncrement();
        this.freqId = UUID.randomUUID();
    }

    public static Collection<LogisticallyLinkedBehaviour> getAllPresent(UUID freq, boolean sortByPriority) {
        return LogisticallyLinkedBehaviour.getAllPresent(freq, sortByPriority, false);
    }

    public static Collection<LogisticallyLinkedBehaviour> getAllPresent(UUID freq, boolean sortByPriority, boolean clientSide) {
        Cache cache = (Cache)(clientSide ? CLIENT_LINKS : LINKS).getIfPresent((Object)freq);
        if (cache == null) {
            return Collections.emptyList();
        }
        Stream<LogisticallyLinkedBehaviour> stream = new LinkedList(cache.asMap().values()).stream().map(Reference::get).filter(LogisticallyLinkedBehaviour::isValidLink);
        if (sortByPriority) {
            stream = stream.sorted((e1, e2) -> Integer.compare(e1.redstonePower, e2.redstonePower));
        }
        return stream.toList();
    }

    public static void keepAlive(LogisticallyLinkedBehaviour behaviour) {
        boolean onClient = behaviour.blockEntity.method_10997().field_9236;
        if (behaviour.redstonePower == 15) {
            return;
        }
        try {
            Cache cache = (Cache)(onClient ? CLIENT_LINKS : LINKS).get((Object)behaviour.freqId, () -> new TickBasedCache(400, false));
            if (cache == null) {
                return;
            }
            WeakReference<LogisticallyLinkedBehaviour> reference = (WeakReference<LogisticallyLinkedBehaviour>)cache.get((Object)behaviour.linkId, () -> new WeakReference<LogisticallyLinkedBehaviour>(behaviour));
            cache.put((Object)behaviour.linkId, (Object)(reference.get() != behaviour ? new WeakReference<LogisticallyLinkedBehaviour>(behaviour) : reference));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void remove(LogisticallyLinkedBehaviour behaviour) {
        Cache cache = (Cache)LINKS.getIfPresent((Object)behaviour.freqId);
        if (cache != null) {
            cache.invalidate((Object)behaviour.linkId);
        }
    }

    @Override
    public void unload() {
        if (this.loadedGlobally && this.global && this.getWorld() != null) {
            Create.LOGISTICS.linkInvalidated(this.freqId, this.getGlobalPos());
        }
        super.unload();
        LogisticallyLinkedBehaviour.remove(this);
    }

    @Override
    public void lazyTick() {
        LogisticallyLinkedBehaviour.keepAlive(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().field_9236) {
            return;
        }
        if (!this.loadedGlobally && this.global) {
            this.loadedGlobally = true;
            Create.LOGISTICS.linkLoaded(this.freqId, this.getGlobalPos());
        }
        if (!this.addedGlobally && this.global) {
            this.addedGlobally = true;
            this.blockEntity.method_5431();
            SmartBlockEntity smartBlockEntity = this.blockEntity;
            if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
                PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
                Create.LOGISTICS.linkAdded(this.freqId, this.getGlobalPos(), plbe.placedBy);
            }
        }
    }

    private class_4208 getGlobalPos() {
        return class_4208.method_19443((class_5321)this.getWorld().method_27983(), (class_2338)this.getPos());
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.addedGlobally && this.global && this.getWorld() != null) {
            Create.LOGISTICS.linkRemoved(this.freqId, this.getGlobalPos());
        }
    }

    public void redstonePowerChanged(int power) {
        if (power == this.redstonePower) {
            return;
        }
        this.redstonePower = power;
        this.blockEntity.method_5431();
        if (power == 15) {
            LogisticallyLinkedBehaviour.remove(this);
        } else {
            LogisticallyLinkedBehaviour.keepAlive(this);
        }
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(class_1799 stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, @Nullable PackageOrderWithCrafts context, @Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
            return plbe.processRequest(stack, amount, address, linkIndex, finalLink, orderId, context, ignoredHandler);
        }
        return null;
    }

    public InventorySummary getSummary(@Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
            return plbe.fetchSummaryFromPackager(ignoredHandler);
        }
        return InventorySummary.EMPTY;
    }

    public void deductFromAccurateSummary(ItemStackHandler packageContents) {
        InventorySummary summary = (InventorySummary)LogisticsManager.ACCURATE_SUMMARIES.getIfPresent((Object)this.freqId);
        if (summary == null) {
            return;
        }
        int size = packageContents.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 orderedStack = packageContents.method_5438(i);
            if (orderedStack.method_7960()) continue;
            summary.add(orderedStack, -Math.min(summary.getCountOf(orderedStack), orderedStack.method_7947()));
        }
    }

    public boolean mayInteract(class_1657 player) {
        return Create.LOGISTICS.mayInteract(this.freqId, player);
    }

    public boolean mayInteractMessage(class_1657 player) {
        boolean mayInteract = Create.LOGISTICS.mayInteract(this.freqId, player);
        if (!mayInteract) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.logistically_linked.protected").method_27692(class_124.field_1061), true);
        }
        return mayInteract;
    }

    public boolean mayAdministrate(class_1657 player) {
        return Create.LOGISTICS.mayAdministrate(this.freqId, player);
    }

    public static boolean isValidLink(LogisticallyLinkedBehaviour link) {
        return link != null && !link.blockEntity.method_11015() && !link.blockEntity.isChunkUnloaded();
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void writeSafe(class_11372 view) {
        view.method_71468("Freq", class_4844.field_25122, (Object)this.freqId);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("Freq", class_4844.field_25122, (Object)this.freqId);
        view.method_71465("Power", this.redstonePower);
        view.method_71472("Added", this.addedGlobally);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.freqId = view.method_71426("Freq", class_4844.field_25122).orElse(null);
        this.redstonePower = view.method_71424("Power", 0);
        this.addedGlobally = view.method_71433("Added", false);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static enum RequestType {
        RESTOCK,
        REDSTONE,
        PLAYER;

    }
}

