/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class DisplayLinkBlockEntity
extends LinkWithBulbBlockEntity
implements TransformableBlockEntity {
    public class_2338 targetOffset = class_2338.field_10980;
    public DisplaySource activeSource;
    private class_2487 sourceConfig = new class_2487();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public int refreshTicks;
    public FactoryPanelSupportBehaviour factoryPanelSupport;
    private static final class_243 bulbOffset = VecHelper.voxelSpace(11.0, 7.0, 5.0);
    private static final class_243 bulbOffsetVertical = VecHelper.voxelSpace(5.0, 7.0, 11.0);

    public DisplayLinkBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DISPLAY_LINK, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.factoryPanelSupport = new FactoryPanelSupportBehaviour(this, () -> false, () -> false, this::updateGatheredData);
        behaviours.add(this.factoryPanelSupport);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks() || !this.activeSource.shouldPassiveReset()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (((Boolean)this.method_11010().method_61767((class_2769)DisplayLinkBlock.POWERED, (Comparable)Boolean.valueOf(true))).booleanValue()) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.field_11863, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        class_2338 sourcePosition = this.getSourcePosition();
        class_2338 targetPosition = this.getTargetPosition();
        if (!this.field_11863.method_8477(targetPosition) || !this.field_11863.method_8477(sourcePosition)) {
            return;
        }
        DisplayTarget target = DisplayTarget.get((class_1936)this.field_11863, targetPosition);
        List<DisplaySource> sources = DisplaySource.getAll((class_1936)this.field_11863, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new class_2487();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.field_11863, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulseNextSync();
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        this.writeGatheredData(view);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        class_2960 id;
        super.write(view, clientPacket);
        this.writeGatheredData(view);
        if (clientPacket && this.activeTarget != null && (id = CreateRegistries.DISPLAY_TARGET.method_10221((Object)this.activeTarget)) != null) {
            view.method_71468("TargetType", class_2960.field_25139, (Object)id);
        }
    }

    private void writeGatheredData(class_11372 view) {
        view.method_71468("TargetOffset", class_2338.field_25064, (Object)this.targetOffset);
        view.method_71465("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            class_2487 data = this.sourceConfig.method_10553();
            class_2960 id = CreateRegistries.DISPLAY_SOURCE.method_10221((Object)this.activeSource);
            if (id != null) {
                data.method_67494("Id", class_2960.field_25139, (Object)id);
            }
            view.method_71468("Source", class_2487.field_25128, (Object)data);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.targetOffset = view.method_71426("TargetOffset", class_2338.field_25064).orElse(class_2338.field_10980);
        this.targetLine = view.method_71424("TargetLine", 0);
        if (clientPacket) {
            view.method_71426("TargetType", class_2960.field_25139).ifPresent(id -> {
                this.activeTarget = DisplayTarget.get(id);
            });
        }
        view.method_71426("Source", class_2487.field_25128).ifPresent(data -> {
            this.activeSource = DisplaySource.get(data.method_67491("Id", class_2960.field_25139).orElse(null));
            this.sourceConfig = this.activeSource != null ? data.method_10553() : new class_2487();
        });
    }

    public void target(class_2338 targetPosition) {
        this.targetOffset = targetPosition.method_10059((class_2382)this.field_11867);
    }

    public class_2338 getSourcePosition() {
        Iterator<FactoryPanelPosition> iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = iterator.next();
            return position.pos();
        }
        return this.field_11867.method_10093(this.getDirection());
    }

    public class_2487 getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(class_2487 sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public class_2350 getDirection() {
        return ((class_2350)this.method_11010().method_61767((class_2769)DisplayLinkBlock.field_10927, (Comparable)class_2350.field_11036)).method_10153();
    }

    public class_2338 getTargetPosition() {
        return this.field_11867.method_10081((class_2382)this.targetOffset);
    }

    @Override
    public class_243 getBulbOffset(class_2680 state) {
        if (((class_2350)state.method_61767((class_2769)DisplayLinkBlock.field_10927, (Comparable)class_2350.field_11036)).method_10166().method_10178()) {
            return bulbOffsetVertical;
        }
        return bulbOffset;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.targetOffset = transform.applyWithoutOffset(this.targetOffset);
        this.notifyUpdate();
    }
}

