package com.zurrtum.create;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_3956;

public class AllAssemblyRecipeNames {
    private static final Map<String, BiFunction<DynamicOps<JsonElement>, JsonObject, class_2561>> ALL = new HashMap<>();

    public static class_2561 get(DynamicOps<JsonElement> ops, JsonObject json) {
        String type = json.get("type").getAsString();
        BiFunction<DynamicOps<JsonElement>, JsonObject, class_2561> factory = ALL.get(type);
        if (factory != null) {
            return factory.apply(ops, json);
        }
        String name;
        if (type.startsWith("create:")) {
            name = type.replaceFirst("create:", "");
        } else {
            name = type.replaceFirst(":", ".");
        }
        return class_2561.method_43471("create.recipe.assembly." + name);
    }

    public static void register(class_3956<?> id, BiFunction<DynamicOps<JsonElement>, JsonObject, class_2561> factory) {
        ALL.put(id.toString(), factory);
    }

    public static void register() {
        register(AllRecipeTypes.DEPLOYING, DeployerApplicationRecipe::getDescriptionForAssembly);
        register(AllRecipeTypes.FILLING, FillingRecipe::getDescriptionForAssembly);
    }
}
