package com.zurrtum.create;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecs;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.component.*;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.util.*;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;

import static com.zurrtum.create.Create.MOD_ID;

public class AllDataComponents {
    public static final class_9331<Integer> FLUID_MAX_CAPACITY = register(
        "fluid_max_capacity",
        builder -> builder.method_57881(class_5699.field_33442).method_57882(class_9135.field_48550)
    );

    public static final class_9331<Integer> BACKTANK_AIR = register(
        "banktank_air",
        builder -> builder.method_57881(class_5699.field_33441).method_57882(class_9135.field_48550)
    );

    public static final class_9331<class_2338> BELT_FIRST_SHAFT = register(
        "belt_first_shaft",
        builder -> builder.method_57881(class_2338.field_25064).method_57882(class_2338.field_48404)
    );

    public static final class_9331<Boolean> INFERRED_FROM_RECIPE = register(
        "inferred_from_recipe",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<PlacementPatterns> PLACEMENT_PATTERN = register(
        "placement_pattern",
        builder -> builder.method_57881(PlacementPatterns.CODEC).method_57882(PlacementPatterns.STREAM_CODEC)
    );

    public static final class_9331<TerrainBrushes> SHAPER_BRUSH = register(
        "shaper_brush",
        builder -> builder.method_57881(TerrainBrushes.CODEC).method_57882(TerrainBrushes.STREAM_CODEC)
    );

    public static final class_9331<class_2338> SHAPER_BRUSH_PARAMS = register(
        "shaper_brush_params",
        builder -> builder.method_57881(class_2338.field_25064).method_57882(class_2338.field_48404)
    );

    public static final class_9331<PlacementOptions> SHAPER_PLACEMENT_OPTIONS = register(
        "shaper_placement_options",
        builder -> builder.method_57881(PlacementOptions.CODEC).method_57882(PlacementOptions.STREAM_CODEC)
    );

    public static final class_9331<TerrainTools> SHAPER_TOOL = register(
        "shaper_tool",
        builder -> builder.method_57881(TerrainTools.CODEC).method_57882(TerrainTools.STREAM_CODEC)
    );

    public static final class_9331<class_2680> SHAPER_BLOCK_USED = register(
        "shaper_block_used",
        builder -> builder.method_57881(class_2680.field_24734).method_57882(class_9135.method_56371(class_2248.field_10651))
    );

    public static final class_9331<Boolean> SHAPER_SWAP = register(
        "shaper_swap",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<class_2487> SHAPER_BLOCK_DATA = register(
        "shaper_block_data",
        builder -> builder.method_57881(class_2487.field_25128).method_57882(class_9135.field_48556)
    );

    public static final class_9331<class_9288> FILTER_ITEMS = register(
        "filter_items",
        builder -> builder.method_57881(class_9288.field_49335).method_57882(class_9288.field_49336)
    );

    // These 2 are placed on items inside filters and not the filter itself
    public static final class_9331<Boolean> FILTER_ITEMS_RESPECT_NBT = register(
        "filter_items_respect_nbt",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<Boolean> FILTER_ITEMS_BLACKLIST = register(
        "filter_items_blacklist",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<AttributeFilterWhitelistMode> ATTRIBUTE_FILTER_WHITELIST_MODE = register(
        "attribute_filter_whitelist_mode",
        builder -> builder.method_57881(AttributeFilterWhitelistMode.CODEC).method_57882(AttributeFilterWhitelistMode.STREAM_CODEC)
    );

    public static final class_9331<List<ItemAttributeEntry>> ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES = register(
        "attribute_filter_matched_attributes",
        builder -> builder.method_57881(ItemAttributeEntry.CODEC.listOf())
            .method_57882(CatnipStreamCodecBuilders.list(ItemAttributeEntry.STREAM_CODEC))
    );

    public static final class_9331<ClipboardContent> CLIPBOARD_CONTENT = register(
        "clipboard_content",
        builder -> builder.method_57881(ClipboardContent.CODEC).method_57882(ClipboardContent.STREAM_CODEC)
    );

    public static final class_9331<ConnectingFrom> TRACK_CONNECTING_FROM = register(
        "track_connecting_from",
        builder -> builder.method_57881(ConnectingFrom.CODEC).method_57882(ConnectingFrom.STREAM_CODEC)
    );

    public static final class_9331<Boolean> TRACK_EXTENDED_CURVE = register(
        "track_extend_curve",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<class_2338> TRACK_TARGETING_ITEM_SELECTED_POS = register(
        "track_targeting_item_selected_pos",
        builder -> builder.method_57881(class_2338.field_25064).method_57882(class_2338.field_48404)
    );

    public static final class_9331<Boolean> TRACK_TARGETING_ITEM_SELECTED_DIRECTION = register(
        "track_targeting_item_selected_direction",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<BezierTrackPointLocation> TRACK_TARGETING_ITEM_BEZIER = register(
        "track_targeting_item_bezier",
        builder -> builder.method_57881(BezierTrackPointLocation.CODEC).method_57882(BezierTrackPointLocation.STREAM_CODEC)
    );

    public static final class_9331<Boolean> SCHEMATIC_DEPLOYED = register(
        "schematic_deployed",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<String> SCHEMATIC_OWNER = register(
        "schematic_owner",
        builder -> builder.method_57881(Codec.STRING).method_57882(class_9135.field_48554)
    );

    public static final class_9331<String> SCHEMATIC_FILE = register(
        "schematic_file",
        builder -> builder.method_57881(Codec.STRING).method_57882(class_9135.field_48554)
    );

    public static final class_9331<class_2338> SCHEMATIC_ANCHOR = register(
        "schematic_anchor",
        builder -> builder.method_57881(class_2338.field_25064).method_57882(class_2338.field_48404)
    );

    public static final class_9331<class_2470> SCHEMATIC_ROTATION = register(
        "schematic_rotation",
        builder -> builder.method_57881(class_2470.field_39313).method_57882(class_2470.field_55987)
    );

    public static final class_9331<class_2415> SCHEMATIC_MIRROR = register(
        "schematic_mirror",
        builder -> builder.method_57881(class_2415.field_39311).method_57882(CatnipStreamCodecs.MIRROR)
    );

    public static final class_9331<class_2382> SCHEMATIC_BOUNDS = register(
        "schematic_bounds",
        builder -> builder.method_57881(class_2382.field_25123).method_57882(class_2382.field_56131)
    );

    public static final class_9331<Integer> SCHEMATIC_HASH = register(
        "schematic_hash",
        builder -> builder.method_57881(Codec.INT).method_57882(class_9135.field_49675)
    );

    public static final class_9331<Integer> CHROMATIC_COMPOUND_COLLECTING_LIGHT = register(
        "chromatic_compound_collecting_light",
        builder -> builder.method_57881(Codec.INT).method_57882(class_9135.field_49675)
    );

    public static final class_9331<SandPaperItemComponent> SAND_PAPER_POLISHING = register(
        "sand_paper_polishing",
        builder -> builder.method_57881(SandPaperItemComponent.CODEC).method_57882(SandPaperItemComponent.STREAM_CODEC)
    );

    public static final class_9331<class_3902> SAND_PAPER_JEI = register(
        "sand_paper_jei",
        builder -> builder.method_57881(class_3902.field_51563).method_57882(class_9139.method_56431(class_3902.field_17274))
    );

    // Holds contraption data when a minecraft contraption is picked up
    public static final class_9331<class_2487> MINECRAFT_CONTRAPTION_DATA = register(
        "minecart_contraption_data",
        builder -> builder.method_57881(class_2487.field_25128).method_57882(class_9135.field_48556)
    );

    public static final class_9331<class_9288> LINKED_CONTROLLER_ITEMS = register(
        "linked_controller_items",
        builder -> builder.method_57881(class_9288.field_49335).method_57882(class_9288.field_49336)
    );

    public static final class_9331<ToolboxInventory> TOOLBOX_INVENTORY = register(
        "toolbox_inventory",
        builder -> builder.method_57881(ToolboxInventory.CODEC).method_57882(ToolboxInventory.STREAM_CODEC)
    );

    public static final class_9331<UUID> TOOLBOX_UUID = register(
        "toolbox_uuid",
        builder -> builder.method_57881(class_4844.field_25122).method_57882(class_4844.field_48453)
    );

    public static final class_9331<Float> SEQUENCED_ASSEMBLY_PROGRESS = register(
        "sequenced_assembly_progress",
        builder -> builder.method_57881(Codec.FLOAT).method_57882(class_9135.field_48552)
    );

    public static final class_9331<SequencedAssemblyJunk> SEQUENCED_ASSEMBLY_JUNK = register(
        "sequenced_assembly_junk",
        builder -> builder.method_57881(SequencedAssemblyJunk.CODEC).method_57882(SequencedAssemblyJunk.PACKET_CODEC)
    );

    public static final class_9331<class_2487> TRAIN_SCHEDULE = register(
        "train_schedule",
        builder -> builder.method_57881(class_2487.field_25128).method_57882(class_9135.field_48556)
    );

    public static final class_9331<SymmetryMirror> SYMMETRY_WAND = register(
        "symmetry_wand",
        builder -> builder.method_57881(SymmetryMirror.CODEC).method_57882(SymmetryMirror.STREAM_CODEC)
    );

    public static final class_9331<Boolean> SYMMETRY_WAND_ENABLE = register(
        "symmetry_wand_enable",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<Boolean> SYMMETRY_WAND_SIMULATE = register(
        "symmetry_wand_simulate",
        builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547)
    );

    public static final class_9331<BottleType> POTION_FLUID_BOTTLE_TYPE = register(
        "potion_fluid_bottle_type",
        builder -> builder.method_57881(BottleType.CODEC).method_57882(BottleType.STREAM_CODEC)
    );

    public static final class_9331<SchematicannonOptions> SCHEMATICANNON_OPTIONS = register(
        "schematicannon_options",
        builder -> builder.method_57881(SchematicannonOptions.CODEC).method_57882(SchematicannonOptions.STREAM_CODEC)
    );

    public static final class_9331<AutoRequestData> AUTO_REQUEST_DATA = register(
        "auto_request_data",
        builder -> builder.method_57881(AutoRequestData.CODEC).method_57882(AutoRequestData.STREAM_CODEC)
    );

    public static final class_9331<ShoppingList> SHOPPING_LIST = register(
        "shopping_list",
        builder -> builder.method_57881(ShoppingList.CODEC).method_57882(ShoppingList.STREAM_CODEC)
    );

    public static final class_9331<String> SHOPPING_LIST_ADDRESS = register(
        "shopping_list_address",
        builder -> builder.method_57881(Codec.STRING).method_57882(class_9135.field_48554)
    );

    public static final class_9331<String> PACKAGE_ADDRESS = register(
        "package_address",
        builder -> builder.method_57881(Codec.STRING).method_57882(class_9135.field_48554)
    );

    public static final class_9331<class_9288> PACKAGE_CONTENTS = register(
        "package_contents",
        builder -> builder.method_57881(class_9288.field_49335).method_57882(class_9288.field_49336)
    );

    public static final class_9331<PackageOrderData> PACKAGE_ORDER_DATA = register(
        "package_order_data",
        builder -> builder.method_57881(PackageOrderData.CODEC).method_57882(PackageOrderData.STREAM_CODEC)
    );

    public static final class_9331<PackageOrderWithCrafts> PACKAGE_ORDER_CONTEXT = register(
        "package_order_context",
        builder -> builder.method_57881(PackageOrderWithCrafts.CODEC).method_57882(PackageOrderWithCrafts.STREAM_CODEC)
    );

    public static final class_9331<ClickToLinkData> CLICK_TO_LINK_DATA = register(
        "click_to_link_data",
        builder -> builder.method_57881(ClickToLinkData.CODEC).method_57882(ClickToLinkData.STREAM_CODEC)
    );

    /**
     * @deprecated Use {@link AllDataComponents#CLIPBOARD_CONTENT} instead.
     */
    @ApiStatus.ScheduledForRemoval(inVersion = "1.21.1+ Port")
    @Deprecated(since = "6.0.7", forRemoval = true)
    public static final class_9331<ClipboardType> CLIPBOARD_TYPE = register(
        "clipboard_type",
        builder -> builder.method_57881(ClipboardType.CODEC).method_57882(ClipboardType.STREAM_CODEC)
    );

    /**
     * @deprecated Use {@link AllDataComponents#CLIPBOARD_CONTENT} instead.
     */
    @ApiStatus.ScheduledForRemoval(inVersion = "1.21.1+ Port")
    @Deprecated(since = "6.0.7", forRemoval = true)
    public static final class_9331<List<List<ClipboardEntry>>> CLIPBOARD_PAGES = register(
        "clipboard_pages",
        builder -> builder.method_57881(ClipboardEntry.CODEC.listOf().listOf())
            .method_57882(CatnipStreamCodecBuilders.list(CatnipStreamCodecBuilders.list(ClipboardEntry.STREAM_CODEC)))
    );

    /**
     * @deprecated Use {@link AllDataComponents#CLIPBOARD_CONTENT} instead.
     */
    @ApiStatus.ScheduledForRemoval(inVersion = "1.21.1+ Port")
    @Deprecated(since = "6.0.7", forRemoval = true)
    public static final class_9331<class_3902> CLIPBOARD_READ_ONLY = register(
        "clipboard_read_only",
        builder -> builder.method_57881(class_3902.field_51563).method_57882(class_9139.method_56431(class_3902.field_17274))
    );

    /**
     * @deprecated Use {@link AllDataComponents#CLIPBOARD_CONTENT} instead.
     */
    @ApiStatus.ScheduledForRemoval(inVersion = "1.21.1+ Port")
    @Deprecated(since = "6.0.7", forRemoval = true)
    public static final class_9331<class_2487> CLIPBOARD_COPIED_VALUES = register(
        "clipboard_copied_values",
        builder -> builder.method_57881(class_2487.field_25128).method_57882(class_9135.field_48556)
    );

    /**
     * @deprecated Use {@link AllDataComponents#CLIPBOARD_CONTENT} instead.
     */
    @ApiStatus.ScheduledForRemoval(inVersion = "1.21.1+ Port")
    @Deprecated(since = "6.0.7", forRemoval = true)
    public static final class_9331<Integer> CLIPBOARD_PREVIOUSLY_OPENED_PAGE = register(
        "clipboard_previously_opened_page",
        builder -> builder.method_57881(Codec.INT).method_57882(class_9135.field_49675)
    );

    private static <T> class_9331<T> register(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(MOD_ID, id),
            builderOperator.apply(class_9331.method_57873()).method_57880()
        );
    }

    public static void register() {
    }
}
