package com.zurrtum.create;

import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

import static com.zurrtum.create.Create.MOD_ID;

public class AllEntityTypes {
    public static final Set<class_1299<?>> NOT_SEND_VELOCITY = new HashSet<>();
    public static final class_1299<EjectorItemEntity> EJECTOR_ITEM = register(
        "ejector_item",
        class_1299.class_1300.<EjectorItemEntity>method_5903(EjectorItemEntity::new, class_1311.field_17715).method_63006().method_17687(0.25F, 0.25F).method_55687(0.2125F)
            .method_27299(6).method_27300(20)
    );
    public static final class_1299<OrientedContraptionEntity> ORIENTED_CONTRAPTION = register(
        "contraption",
        class_1299.class_1300.method_5903(OrientedContraptionEntity::new, class_1311.field_17715).method_17687(1, 1).method_19947()
    );
    public static final class_1299<ControlledContraptionEntity> CONTROLLED_CONTRAPTION = register(
        "stationary_contraption",
        class_1299.class_1300.method_5903(ControlledContraptionEntity::new, class_1311.field_17715).method_17687(1, 1).method_27299(20).method_27300(40).method_19947()
    );
    public static final class_1299<CarriageContraptionEntity> CARRIAGE_CONTRAPTION = register(
        "carriage_contraption",
        class_1299.class_1300.method_5903(CarriageContraptionEntity::new, class_1311.field_17715).method_17687(1, 1).method_27299(15).method_19947()
    );
    public static final class_1299<SuperGlueEntity> SUPER_GLUE = register(
        "super_glue",
        class_1299.class_1300.<SuperGlueEntity>method_5903(SuperGlueEntity::new, class_1311.field_17715).method_27299(10).method_27300(Integer.MAX_VALUE)
            .method_19947()
    );
    public static final class_1299<GantryContraptionEntity> GANTRY_CONTRAPTION = register(
        "gantry_contraption",
        class_1299.class_1300.method_5903(GantryContraptionEntity::new, class_1311.field_17715).method_17687(1, 1).method_27299(10).method_27300(40).method_19947()
    );
    public static final class_1299<SeatEntity> SEAT = register(
        "seat",
        class_1299.class_1300.<SeatEntity>method_5903(SeatEntity::new, class_1311.field_17715).method_27300(Integer.MAX_VALUE).method_19947().method_17687(0.25f, 0.35f)
    );
    public static final class_1299<PotatoProjectileEntity> POTATO_PROJECTILE = register(
        "potato_projectile",
        class_1299.class_1300.method_5903(PotatoProjectileEntity::new, class_1311.field_17715).method_27299(4).method_27300(20).method_17687(.25f, .25f)
    );
    public static final class_1299<PackageEntity> PACKAGE = register(
        "package",
        class_1299.class_1300.<PackageEntity>method_5903(PackageEntity::new, class_1311.field_17715).method_27299(10).method_27300(3).method_17687(1, 1)
    );
    public static final class_1299<BlueprintEntity> CRAFTING_BLUEPRINT = register(
        "crafting_blueprint",
        class_1299.class_1300.<BlueprintEntity>method_5903(BlueprintEntity::new, class_1311.field_17715).method_27299(10).method_27300(Integer.MAX_VALUE)
            .method_19947()
    );

    private static <T extends class_1297> class_1299<T> register(String id, class_1299.class_1300<T> type) {
        class_5321<class_1299<?>> key = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID, id));
        return class_2378.method_39197(class_7923.field_41177, key, type.method_5905(key));
    }

    public static void register() {
        NOT_SEND_VELOCITY.add(SUPER_GLUE);
        NOT_SEND_VELOCITY.add(CONTROLLED_CONTRAPTION);
        NOT_SEND_VELOCITY.add(GANTRY_CONTRAPTION);
        NOT_SEND_VELOCITY.add(SEAT);
        NOT_SEND_VELOCITY.add(CRAFTING_BLUEPRINT);
    }
}
