package com.zurrtum.create;

import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import com.zurrtum.create.infrastructure.fluids.FluidEntry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

import static com.zurrtum.create.Create.MOD_ID;

public class AllFluids {
    public static final List<FlowableFluid> ALL = new ArrayList<>();
    public static final FlowableFluid POTION = register("potion");
    public static final FlowableFluid TEA = register("tea");
    public static final FlowableFluid MILK = register("milk");
    public static final FlowableFluid HONEY = register("honey");
    public static final FlowableFluid CHOCOLATE = register("chocolate");

    private static FlowableFluid register(String name) {
        class_2960 id = class_2960.method_60655(MOD_ID, name);
        class_5321<class_3611> still_key = class_5321.method_29179(class_7924.field_41270, id);
        class_5321<class_3611> flowing_key = class_5321.method_29179(class_7924.field_41270, id.method_45138("flowing_"));
        FluidEntry entry = new FluidEntry();
        entry.still = new FlowableFluid.Still(entry);
        entry.flowing = new FlowableFluid.Flowing(entry);
        class_2378.method_39197(class_7923.field_41173, still_key, entry.still);
        class_2378.method_39197(class_7923.field_41173, flowing_key, entry.flowing);
        ALL.add(entry.still);
        ALL.add(entry.flowing);
        return entry.still;
    }

    public static void register() {
    }
}
