package com.zurrtum.create;

import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.OptionalMountedDispenseBehavior;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_10690;
import net.minecraft.class_10691;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1541;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;

public class AllMountedDispenseItemBehaviors {
    private static final MountedDispenseBehavior SPAWN_EGG = new DefaultMountedDispenseBehavior() {
        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            if (!(stack.method_7909() instanceof class_1826 egg))
                return super.execute(stack, context, pos, facing);

            if (context.world instanceof class_3218 serverLevel) {
                class_1299<?> type = egg.method_8015(stack);
                class_2338 offset = class_2338.method_49637(facing.field_1352 + .7, facing.field_1351 + .7, facing.field_1350 + .7);
                class_1297 entity = type.method_5894(serverLevel, stack, null, pos.method_10081(offset), class_3730.field_16470, facing.field_1351 < .5, false);
                if (entity != null) {
                    entity.method_18799(context.motion.method_1021(2));
                }
            }

            stack.method_7934(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior TNT = new DefaultMountedDispenseBehavior() {
        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            double x = pos.method_10263() + facing.field_1352 * .7 + .5;
            double y = pos.method_10264() + facing.field_1351 * .7 + .5;
            double z = pos.method_10260() + facing.field_1350 * .7 + .5;
            class_1541 tnt = new class_1541(context.world, x, y, z, null);
            tnt.method_5762(context.motion.field_1352, context.motion.field_1351, context.motion.field_1350);
            context.world.method_8649(tnt);
            context.world.method_43128(null, tnt.method_23317(), tnt.method_23318(), tnt.method_23321(), class_3417.field_15079, class_3419.field_15245, 1, 1);
            stack.method_7934(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior FIREWORK = new DefaultMountedDispenseBehavior() {
        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            double x = pos.method_10263() + facing.field_1352 * .7 + .5;
            double y = pos.method_10264() + facing.field_1351 * .7 + .5;
            double z = pos.method_10260() + facing.field_1350 * .7 + .5;
            class_1671 firework = new class_1671(context.world, stack, x, y, z, true);
            firework.method_7485(facing.field_1352, facing.field_1351, facing.field_1350, 0.5F, 1.0F);
            context.world.method_8649(firework);
            stack.method_7934(1);
            return stack;
        }

        @Override
        protected void playSound(class_1936 level, class_2338 pos) {
            level.method_20290(class_6088.field_31162, pos, 0);
        }
    };
    private static final MountedDispenseBehavior FIRE_CHARGE = new DefaultMountedDispenseBehavior() {
        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            class_5819 random = context.world.field_9229;
            double x = pos.method_10263() + facing.field_1352 * .7 + .5;
            double y = pos.method_10264() + facing.field_1351 * .7 + .5;
            double z = pos.method_10260() + facing.field_1350 * .7 + .5;
            class_1677 fireball = new class_1677(
                context.world, x, y, z, new class_243(
                random.method_43059() * 0.05 + facing.field_1352 + context.motion.field_1352,
                random.method_43059() * 0.05 + facing.field_1351 + context.motion.field_1351,
                random.method_43059() * 0.05 + facing.field_1350 + context.motion.field_1350
            ).method_1029()
            );
            fireball.method_16936(stack); // copies the stack
            context.world.method_8649(fireball);
            stack.method_7934(1);
            return stack;
        }

        @Override
        protected void playSound(class_1936 level, class_2338 pos) {
            level.method_20290(class_6088.field_31176, pos, 0);
        }
    };
    private static final MountedDispenseBehavior BUCKET = new DefaultMountedDispenseBehavior() {
        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            class_2338 interactionPos = pos.method_10093(MountedDispenseBehavior.getClosestFacingDirection(facing));
            class_2680 state = context.world.method_8320(interactionPos);
            if (!(state.method_26204() instanceof class_2263 bucketPickup)) {
                return super.execute(stack, context, pos, facing);
            }

            class_1799 bucket = bucketPickup.method_9700(null, context.world, interactionPos, state);
            MountedDispenseBehavior.placeItemInInventory(bucket, context, pos);
            stack.method_7934(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior SPLASH_POTIONS = new MountedProjectileDispenseBehavior() {
        @Override
        protected class_1676 getProjectile(class_1937 level, double x, double y, double z, class_1799 stack, class_2350 facing) {
            return new class_10691(level, x, y, z, stack);
        }

        @Override
        protected float getUncertainty() {
            return super.getUncertainty() * 0.5f;
        }

        @Override
        protected float getPower() {
            return super.getPower() * 1.25f;
        }
    };
    private static final MountedDispenseBehavior LINGERING_POTIONS = new MountedProjectileDispenseBehavior() {
        @Override
        protected class_1676 getProjectile(class_1937 level, double x, double y, double z, class_1799 stack, class_2350 facing) {
            return new class_10690(level, x, y, z, stack);
        }

        @Override
        protected float getUncertainty() {
            return super.getUncertainty() * 0.5f;
        }

        @Override
        protected float getPower() {
            return super.getPower() * 1.25f;
        }
    };
    private static final MountedDispenseBehavior BOTTLE = new OptionalMountedDispenseBehavior() {
        @Override
        @Nullable
        protected class_1799 doExecute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            class_2338 interactionPos = pos.method_10093(MountedDispenseBehavior.getClosestFacingDirection(facing));
            class_2680 state = context.world.method_8320(interactionPos);
            class_2248 block = state.method_26204();

            if (block instanceof class_4481 hive && state.method_26164(class_3481.field_20340) && state.method_11654(class_4481.field_20420) >= 5) {
                hive.method_21841(context.world, state, interactionPos, null, class_4482.class_4484.field_20429);
                MountedDispenseBehavior.placeItemInInventory(new class_1799(class_1802.field_20417), context, pos);
                stack.method_7934(1);
                return stack;
            } else if (context.world.method_8316(interactionPos).method_15767(class_3486.field_15517)) {
                class_1799 waterBottle = class_1844.method_57400(class_1802.field_8574, class_1847.field_8991);
                MountedDispenseBehavior.placeItemInInventory(waterBottle, context, pos);
                stack.method_7934(1);
                return stack;
            } else {
                return null;
            }
        }
    };

    public static void register() {
        MountedDispenseBehavior.REGISTRY.registerProvider(item -> item instanceof class_1826 ? SPAWN_EGG : null);

        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8626, TNT);
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8639, FIREWORK);
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8814, FIRE_CHARGE);
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8550, BUCKET);
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8469, BOTTLE);

        // potions can't be automatically converted since they use a weird wrapper thing
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8436, SPLASH_POTIONS);
        MountedDispenseBehavior.REGISTRY.register(class_1802.field_8150, LINGERING_POTIONS);
    }
}
