package com.zurrtum.create;

import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingRecipe;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10290;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

import static com.zurrtum.create.Create.MOD_ID;

public class AllRecipeSets {
    public static final Map<class_5321<class_10290>, class_1863.class_10357> ALL = new IdentityHashMap<>();
    public static final class_5321<class_10290> ITEM_APPLICATION_TARGET = register("item_application_target");
    public static final class_5321<class_10290> ITEM_APPLICATION_INGREDIENT = register("item_application_ingredient");
    public static final class_5321<class_10290> EMPTYING = register("emptying");
    public static final class_5321<class_10290> FILLING = register("filling");
    public static final class_5321<class_10290> SAND_PAPER_POLISHING = register("sand_paper_polishing");
    public static final class_5321<class_10290> SPLASHING = register("splashing");
    public static final class_5321<class_10290> HAUNTING = register("haunting");
    public static final class_5321<class_10290> CRUSHING = register("crushing");
    public static final class_5321<class_10290> MILLING = register("milling");

    private static class_5321<class_10290> register(String id) {
        return class_5321.method_29179(class_10290.field_54646, class_2960.method_60655(MOD_ID, id));
    }

    @SuppressWarnings("unchecked")
    private static <T extends class_1860<?>> void register(class_5321<class_10290> key, Class<T> type, Function<T, class_1856> getter) {
        ALL.put(
            key, recipe -> {
                if (type.isInstance(recipe)) {
                    return Optional.of(getter.apply((T) recipe));
                } else {
                    return Optional.empty();
                }
            }
        );
    }

    public static void register() {
        register(ITEM_APPLICATION_TARGET, ManualApplicationRecipe.class, ManualApplicationRecipe::target);
        register(ITEM_APPLICATION_INGREDIENT, ManualApplicationRecipe.class, ManualApplicationRecipe::ingredient);
        register(EMPTYING, EmptyingRecipe.class, EmptyingRecipe::ingredient);
        register(FILLING, FillingRecipe.class, FillingRecipe::ingredient);
        register(SAND_PAPER_POLISHING, SandPaperPolishingRecipe.class, SandPaperPolishingRecipe::ingredient);
        register(SPLASHING, SplashingRecipe.class, SplashingRecipe::ingredient);
        register(HAUNTING, HauntingRecipe.class, HauntingRecipe::ingredient);
        register(CRUSHING, CrushingRecipe.class, CrushingRecipe::ingredient);
        register(MILLING, MillingRecipe.class, MillingRecipe::ingredient);
    }
}
