package com.zurrtum.create.api.behaviour.display;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDisplayTargets;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class DisplayTarget {
    public static final SimpleRegistry<class_2248, DisplayTarget> BY_BLOCK = SimpleRegistry.create();
    public static final SimpleRegistry<class_2591<?>, DisplayTarget> BY_BLOCK_ENTITY = SimpleRegistry.create();

    public abstract void acceptText(int line, List<class_5250> text, DisplayLinkContext context);

    public abstract DisplayTargetStats provideStats(DisplayLinkContext context);

    public class_2561 getLineOptionText(int line) {
        return class_2561.method_43469("create.display_target.line", line + 1);
    }

    public static void reserve(int line, DisplayHolder target, DisplayLinkContext context) {
        if (line == 0)
            return;

        target.updateLine(line, context.blockEntity().method_11016());
    }

    public boolean isReserved(int line, DisplayHolder target, DisplayLinkContext context) {
        class_2338 reserved = target.getLine(line);
        if (reserved == null) {
            return false;
        }

        if (!reserved.equals(context.blockEntity().method_11016()) && context.level().method_8320(reserved).method_27852(AllBlocks.DISPLAY_LINK))
            return true;

        target.removeLine(line);
        return false;
    }

    public boolean requiresComponentSanitization() {
        return false;
    }

    /**
     * Get the DisplayTarget with the given ID, accounting for legacy names.
     */
    @Nullable
    public static DisplayTarget get(@Nullable class_2960 id) {
        if (id == null)
            return null;
        return CreateRegistries.DISPLAY_TARGET.method_63535(id);
    }

    /**
     * Get the DisplayTarget applicable to the given location, or null if there isn't one.
     */
    @Nullable
    public static DisplayTarget get(class_1936 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        DisplayTarget byBlock = BY_BLOCK.get(state);
        // block takes priority if present, it's more granular
        if (byBlock != null)
            return byBlock;

        class_2586 be = level.method_8321(pos);
        if (be == null)
            return null;

        DisplayTarget byBe = BY_BLOCK_ENTITY.get(be.method_11017());
        if (byBe != null)
            return byBe;

        // special case: modded signs are common
        return be instanceof class_2625 ? AllDisplayTargets.SIGN : null;
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_265 shape = level.method_8320(pos).method_26218(level, pos);
        if (shape.method_1110())
            return new class_238(pos);
        return shape.method_1107().method_996(pos);
    }
}
