package com.zurrtum.create.api.contraption.dispenser;

import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;

/**
 * A mounted dispenser behavior that might fail, playing the empty sound if it does.
 */
public class OptionalMountedDispenseBehavior extends DefaultMountedDispenseBehavior {
    private boolean success;

    @Override
    protected final class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
        class_1799 remainder = this.doExecute(stack, context, pos, facing);
        this.success = remainder != null;
        return remainder == null ? stack : remainder;
    }

    @Override
    protected void playSound(class_1936 level, class_2338 pos) {
        if (this.success) {
            super.playSound(level, pos);
        } else {
            level.method_20290(class_6088.field_31159, pos, 0);
        }
    }

    /**
     * Dispense the given item.
     *
     * @return the remaining items after dispensing one, or null if it failed
     */
    @Nullable
    protected class_1799 doExecute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
        return super.execute(stack, context, pos, facing);
    }
}
