package com.zurrtum.create.api.contraption.storage.fluid;

import com.mojang.serialization.Codec;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class MountedFluidStorage implements FluidInventory {
    public static final Codec<MountedFluidStorage> CODEC = MountedFluidStorageType.CODEC.dispatch(storage -> storage.type, type -> type.codec);

    @SuppressWarnings("deprecation")
    public static final class_9139<class_9129, MountedFluidStorage> STREAM_CODEC = class_9139.method_56437(
        (b, t) -> b.method_29172(class_6903.method_46632(class_2509.field_11560, b.method_56349()), CODEC, t),
        b -> b.method_52954(class_6903.method_46632(class_2509.field_11560, b.method_56349()), CODEC)
    );

    public final MountedFluidStorageType<? extends MountedFluidStorage> type;

    protected MountedFluidStorage(MountedFluidStorageType<?> type) {
        this.type = Objects.requireNonNull(type);
    }

    /**
     * Un-mount this storage back into the world. The expected storage type of the target
     * block has already been checked to make sure it matches this storage's type.
     */
    public abstract void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be);
}
