package com.zurrtum.create.catnip.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class IntAttached<V> extends Pair<Integer, V> {

    protected IntAttached(Integer first, V second) {
        super(first, second);
    }

    public static <V> IntAttached<V> with(int number, V value) {
        return new IntAttached<>(number, value);
    }

    public static <V> IntAttached<V> withZero(V value) {
        return new IntAttached<>(0, value);
    }

    public boolean isZero() {
        return first == 0;
    }

    public boolean exceeds(int value) {
        return first > value;
    }

    public boolean isOrBelowZero() {
        return first <= 0;
    }

    public void increment() {
        first++;
    }

    public void decrement() {
        first--;
    }

    public V getValue() {
        return getSecond();
    }

    public class_2487 serializeNBT(Function<V, class_2487> serializer) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("Item", serializer.apply(getValue()));
        nbt.method_10569("Location", getFirst());
        return nbt;
    }

    public static Comparator<? super IntAttached<?>> comparator() {
        return (i1, i2) -> Integer.compare(i2.getFirst(), i1.getFirst());
    }

    public static <T> IntAttached<T> read(class_2487 nbt, Function<class_2487, T> deserializer) {
        return IntAttached.with(nbt.method_68083("Location", 0), deserializer.apply(nbt.method_68568("Item")));
    }

    public static <T> Codec<IntAttached<T>> codec(Codec<T> codec) {
        return RecordCodecBuilder.create(instance -> instance.group(
            Codec.INT.fieldOf("first").forGetter(IntAttached::getFirst),
            codec.fieldOf("second").forGetter(IntAttached::getSecond)
        ).apply(instance, IntAttached::new));
    }

    public static <B extends class_2540, T> class_9139<B, IntAttached<T>> streamCodec(class_9139<? super B, T> codec) {
        return class_9139.method_56435(class_9135.field_49675, Pair::getFirst, codec, Pair::getSecond, IntAttached::new);
    }
}
