package com.zurrtum.create.catnip.levelWrappers;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import com.zurrtum.create.catnip.math.BBHelper;
import java.util.*;
import java.util.function.Predicate;
import net.minecraft.class_12131;
import net.minecraft.class_12206;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_5425;
import net.minecraft.class_6754;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class SchematicLevel extends WrappedLevel implements class_5425, SchematicLevelAccessor {
    protected Map<class_2338, class_2680> blocks;
    protected Map<class_2338, class_2586> blockEntities;
    protected List<class_2586> renderedBlockEntities;
    protected List<class_1297> entities;
    protected class_3341 bounds;

    public class_2338 anchor;
    public boolean renderMode;

    public SchematicLevel(class_1937 original) {
        this(class_2338.field_10980, original);
    }

    public SchematicLevel(class_2338 anchor, class_1937 original) {
        super(original);
        setChunkSource(new SchematicChunkSource(this));
        this.blocks = new HashMap<>();
        this.blockEntities = new HashMap<>();
        this.bounds = new class_3341(class_2338.field_10980);
        this.anchor = anchor;
        this.entities = new ArrayList<>();
        this.renderedBlockEntities = new ArrayList<>();
    }

    @Override
    public class_1266 method_8404(class_2338 pos) {
        long localTime = 0L;
        float moonBrightness = 0.0F;
        class_2791 chunk = level.method_8402(
            class_4076.method_18675(pos.method_10263()),
            class_4076.method_18675(pos.method_10260()),
            class_2806.field_12803,
            false
        );
        if (chunk != null) {
            localTime = chunk.method_12033();
            class_12131 moonPhase = level.method_75728().method_75697(class_12206.field_64343, pos);
            moonBrightness = class_2874.field_24752[moonPhase.method_75261()];
        }
        return new class_1266(level.method_8407(), level.method_8532(), localTime, moonBrightness);
    }

    @Override
    public Set<class_2338> getAllPositions() {
        return blocks.keySet();
    }

    @Override
    public boolean method_8649(class_1297 entityIn) {
        if (entityIn instanceof class_1533 itemFrame)
            itemFrame.method_6935(ComponentProcessors.withUnsafeComponentsDiscarded(itemFrame.method_6940()));
        if (entityIn instanceof class_1531 armorStand)
            for (class_1304 equipmentSlot : class_1304.values())
                armorStand.method_5673(equipmentSlot, ComponentProcessors.withUnsafeComponentsDiscarded(armorStand.method_6118(equipmentSlot)));

        return entities.add(entityIn);
    }

    @Override
    public List<class_1297> getEntityList() {
        return entities;
    }

    @Override
    public class_2586 method_8321(class_2338 pos) {
        if (method_31606(pos))
            return null;
        if (blockEntities.containsKey(pos))
            return blockEntities.get(pos);
        if (!blocks.containsKey(pos.method_10059(anchor)))
            return null;

        class_2680 blockState = method_8320(pos);
        if (blockState.method_31709()) {
            try {
                class_2586 blockEntity = ((class_2343) blockState.method_26204()).method_10123(pos, blockState);
                if (blockEntity != null) {
                    onBEadded(blockEntity, pos);
                    blockEntities.put(pos, blockEntity);
                    renderedBlockEntities.add(blockEntity);
                }
                return blockEntity;
            } catch (Exception e) {
                Create.LOGGER.debug("Could not create BlockEntity of block " + blockState, e);
            }
        }
        return null;
    }

    protected void onBEadded(class_2586 blockEntity, class_2338 pos) {
        blockEntity.method_31662(this);
    }

    @Override
    public class_2680 method_8320(class_2338 globalPos) {
        class_2338 pos = globalPos.method_10059(anchor);

        if (pos.method_10264() - bounds.method_35416() == -1 && !renderMode)
            return class_2246.field_10566.method_9564();
        if (getBounds().method_14662(pos) && blocks.containsKey(pos))
            return processBlockStateForPrinting(blocks.get(pos));
        return class_2246.field_10124.method_9564();
    }

    @Override
    public Map<class_2338, class_2680> getBlockMap() {
        return blocks;
    }

    @Override
    public class_3610 method_8316(class_2338 pos) {
        return method_8320(pos).method_26227();
    }

    @Override
    public class_6880<class_1959> method_23753(class_2338 pos) {
        return level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451);
        //return ForgeRegistries.BIOMES.getHolder(Biomes.PLAINS.location()).orElse(null);
    }

    @Override
    public int method_8314(class_1944 lightLayer, class_2338 pos) {
        return 15;
    }

    @Override
    public float method_24852(class_2350 face, boolean hasShade) {
        return 1f;
    }

    @Override
    public class_6756<class_2248> method_8397() {
        return class_6754.method_39362();
    }

    @Override
    public class_6756<class_3611> method_8405() {
        return class_6754.method_39362();
    }

    @Override
    public List<class_1297> method_8333(class_1297 arg0, class_238 arg1, Predicate<? super class_1297> arg2) {
        return Collections.emptyList();
    }

    @Override
    public <T extends class_1297> List<T> method_8390(Class<T> arg0, class_238 arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends class_1657> method_18456() {
        return Collections.emptyList();
    }

    @Override
    public int method_8594() {
        return 0;
    }

    @Override
    public boolean method_16358(class_2338 pos, Predicate<class_2680> predicate) {
        return predicate.test(method_8320(pos));
    }

    @Override
    public boolean method_22352(class_2338 arg0, boolean arg1) {
        return method_8652(arg0, class_2246.field_10124.method_9564(), 3);
    }

    @Override
    public boolean method_8650(class_2338 arg0, boolean arg1) {
        return method_8652(arg0, class_2246.field_10124.method_9564(), 3);
    }

    @Override
    public boolean method_8652(class_2338 pos, class_2680 arg1, int arg2) {
        pos = pos.method_10062().method_10059(anchor);
        bounds = BBHelper.encapsulate(bounds, pos);
        blocks.put(pos, arg1);
        if (blockEntities.containsKey(pos)) {
            class_2586 blockEntity = blockEntities.get(pos);
            if (!blockEntity.method_11017().method_20526(arg1)) {
                blockEntities.remove(pos);
                renderedBlockEntities.remove(blockEntity);
            }
        }

        class_2586 blockEntity = method_8321(pos);
        if (blockEntity != null)
            blockEntities.put(pos, blockEntity);

        return true;
    }

    @Override
    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
    }

    @Override
    public class_3341 getBounds() {
        return bounds;
    }

    @Override
    public void setBounds(class_3341 bounds) {
        this.bounds = bounds;
    }

    @Override
    public Iterable<class_2586> getBlockEntities() {
        return blockEntities.values();
    }

    @Override
    public Iterable<class_2586> getRenderedBlockEntities() {
        return renderedBlockEntities;
    }

    protected class_2680 processBlockStateForPrinting(class_2680 state) {
        if (state.method_26204() instanceof class_2363 && state.method_28498(class_2741.field_12548))
            state = state.method_11657(class_2741.field_12548, false);
        return state;
    }

    @Override
    public class_3218 method_8410() {
        if (level instanceof class_3218 serverWorld) {
            return serverWorld;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}
