package com.zurrtum.create.client.catnip.animation;

import com.zurrtum.create.client.catnip.levelWrappers.WrappedClientLevel;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import net.minecraft.class_1936;
import net.minecraft.class_310;
import net.minecraft.class_9779;

public class AnimationTickHolder {

    private static int ticks;
    private static int pausedTicks;

    public static void reset() {
        ticks = 0;
        pausedTicks = 0;
    }

    public static void tick() {
        if (!class_310.method_1551().method_1493()) {
            ticks = (ticks + 1) % 1_728_000; // wrap around every 24 hours so we maintain enough floating point precision
        } else {
            pausedTicks = (pausedTicks + 1) % 1_728_000;
        }
    }

    public static int getTicks() {
        return getTicks(false);
    }

    public static int getTicks(boolean includePaused) {
        return includePaused ? ticks + pausedTicks : ticks;
    }

    public static int getTicks(class_1936 level) {
        if (level instanceof WrappedClientLevel wrappedLevel) {
            return getTicks(wrappedLevel.getWrappedLevel());
        } else if (level instanceof PonderLevel) {
            return PonderUI.ponderTicks;
        }
        return getTicks();
    }

    public static float getPartialTicks(class_1936 level) {
        if (level instanceof PonderLevel) {
            return PonderUI.getPartialTicks();
        }
        return getPartialTicks();
    }

    public static float getRenderTime() {
        return getTicks() + getPartialTicks();
    }

    public static float getRenderTime(class_1936 level) {
        return getTicks(level) + getPartialTicks(level);
    }

    /**
     * @return the fraction between the current tick to the next tick, frozen during game pause [0-1]
     */
    public static float getPartialTicks() {
        class_310 mc = class_310.method_1551();
        return mc.method_61966().method_60637(false);
    }

    /**
     * @return the fraction between the current tick to the next tick, not frozen during game pause [0-1]
     */
    public static float getPartialTicksUI(class_9779 timer) {
        if (timer instanceof class_9779.class_9781 timerAccessor) {
            return timerAccessor.field_51959;
        } else {
            return timer.method_60637(false);
        }
    }
}