package com.zurrtum.create.client.catnip.gui.element;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.minecraft.class_332;
import org.lwjgl.opengl.GL11;

public interface StencilElement extends RenderElement {

    @Override
    default void render(class_332 graphics) {
        graphics.method_51448().pushMatrix();
        transform(graphics);
        prepareStencil(graphics);
        renderStencil(graphics);
        prepareElement(graphics);
        renderElement(graphics);
        cleanUp(graphics);
        graphics.method_51448().popMatrix();
    }

    void renderStencil(class_332 graphics);

    void renderElement(class_332 graphics);

    default void transform(class_332 graphics) {
        graphics.method_51448().translate(getX(), getY());
    }

    default void prepareStencil(class_332 graphics) {
        //        graphics.draw();
        GL11.glDisable(GL11.GL_STENCIL_TEST);
        GL11.glStencilMask(~0);
        GlStateManager._clear(GL11.GL_STENCIL_BUFFER_BIT);
        GL11.glEnable(GL11.GL_STENCIL_TEST);
        GL11.glStencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);
        GL11.glStencilMask(0xFF);
        GL11.glStencilFunc(GL11.GL_NEVER, 1, 0xFF);
    }

    default void prepareElement(class_332 graphics) {
        GL11.glEnable(GL11.GL_STENCIL_TEST);
        GL11.glStencilOp(GL11.GL_KEEP, GL11.GL_KEEP, GL11.GL_KEEP);
        GL11.glStencilFunc(GL11.GL_EQUAL, 1, 0xFF);
    }

    default void cleanUp(class_332 graphics) {
        GL11.glDisable(GL11.GL_STENCIL_TEST);
        //        graphics.draw();

    }
}
