package com.zurrtum.create.client.catnip.gui.render;

import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11256;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8030;

public record BlockTransformRenderState(
    class_2680 state, List<class_10889> parts, Matrix3x2f pose, class_8030 bounds, int x0, int y0, int x1, int y1, int padding, float scale,
    float xRot, float yRot, float zRot, @Nullable class_8030 scissorArea
) implements class_11256 {
    public static BlockTransformRenderState create(
        class_332 graphics,
        class_2680 block,
        float x,
        float y,
        float scale,
        int padding,
        float xRot,
        float yRot,
        float zRot
    ) {
        float size = scale * 16 + padding;
        class_310 mc = graphics.field_44656;
        List<class_10889> parts = mc.method_1541().method_3349(block).method_68512(mc.field_1687.field_9229);
        Matrix3x2f pose = new Matrix3x2f(graphics.method_51448());
        int x1 = (int) x;
        int y1 = (int) y;
        int x2 = (int) (x + size);
        int y2 = (int) (y + size);
        class_8030 bounds = new class_8030(x1, y1, (int) size, (int) size).method_71523(pose);
        class_8030 scissor = graphics.field_44659.method_70863();
        if (scissor != null) {
            bounds = bounds.method_49701(scissor);
        }
        return new BlockTransformRenderState(block, parts, pose, bounds, x1, y1, x2, y2, padding, size, xRot, yRot, zRot, scissor);
    }

    public Object getKey() {
        return List.of(state, scale, padding, xRot, yRot, zRot);
    }

    public static Object getKey(class_2680 state, float scale, int padding, float xRot, float yRot, float zRot) {
        return List.of(state, scale * 16 + padding, padding, xRot, yRot, zRot);
    }
}
