package com.zurrtum.create.client.catnip.impl.client.render.model;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.minecraft.class_11515;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_9799;
import org.jetbrains.annotations.UnknownNullability;

// Modified from https://github.com/Engine-Room/Flywheel/blob/2f67f54c8898d91a48126c3c753eefa6cd224f84/fabric/src/lib/java/dev/engine_room/flywheel/lib/model/baked/MeshEmitter.java
class MeshEmitter {
    private final class_11515 renderType;
    private final class_9799 byteBufferBuilder;
    @UnknownNullability
    private class_287 bufferBuilder;

    @UnknownNullability
    private ShadeSeparatedResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(class_11515 renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new class_9799(renderType.method_72021());
    }

    public void prepare(ShadeSeparatedResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (bufferBuilder != null) {
            emit();
        }
        resultConsumer = null;
    }

    public class_287 getBuffer(boolean shade) {
        prepareForGeometry(shade);
        return bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (bufferBuilder == null) {
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        } else if (shade != currentShade) {
            emit();
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        }

        currentShade = shade;
    }

    private void emit() {
        var data = bufferBuilder.method_60794();
        bufferBuilder = null;

        if (data != null) {
            resultConsumer.accept(renderType, currentShade, data);
            data.close();
        }
    }
}
