package com.zurrtum.create.client.catnip.lang;

import org.joml.Matrix4f;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_765;

public class ClientFontHelper {

    public static List<String> cutString(class_327 font, String text, int maxWidthPerLine) {
        // Split words
        List<String> words = new LinkedList<>();
        String selected = class_310.method_1551().method_1526().method_4669();
        final String[] langSplit = selected.split("_", 2);
        Locale locale = langSplit.length == 1 ? Locale.of(langSplit[0]) : Locale.of(langSplit[0], langSplit[1]);
        BreakIterator iterator = BreakIterator.getLineInstance(locale);
        iterator.setText(text);
        int start = iterator.first();
        for (int end = iterator.next(); end != BreakIterator.DONE; start = end, end = iterator.next()) {
            String word = text.substring(start, end);
            words.add(word);
        }
        // Apply hard wrap
        List<String> lines = new LinkedList<>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.method_1727(word);
            if (width + newWidth > maxWidthPerLine) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static void drawSplitString(class_332 graphics, class_327 font, String text, int x, int y, int width, int color) {
        List<String> list = cutString(font, text, width);

        boolean rightToLeft = font.method_1726();
        for (String s : list) {
            int f = x;
            if (rightToLeft) {
                int i = font.method_1727(font.method_1721(s));
                f += width - i;
            }

            draw(graphics, font, s, f, y, color);
            y += 9;
        }
    }

    private static void draw(class_332 graphics, class_327 font, String text, int x, int y, int color) {
        if (text != null) {
            graphics.method_51433(font, text, x, y, color, false);
        }
    }

    public static void drawSplitString(class_4597 buffer, class_4587 matrixStack, class_327 font, String text, int x, int y, int width, int color) {
        List<String> list = cutString(font, text, width);
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();

        boolean rightToLeft = font.method_1726();
        for (String s : list) {
            int f = x;
            if (rightToLeft) {
                int i = font.method_1727(font.method_1721(s));
                f += width - i;
            }

            draw(buffer, font, s, f, y, color, matrix4f);
            y += 9;
        }
    }

    private static void draw(class_4597 buffer, class_327 font, String text, int x, int y, int color, Matrix4f matrix4f) {
        font.method_27521(text, x, y, color, false, matrix4f, buffer, class_327.class_6415.field_33993, 0, class_765.field_32767);
    }
}