package com.zurrtum.create.client.catnip.outliner;

import com.zurrtum.create.client.catnip.render.BindableTexture;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AABBOutline extends Outline {

    protected class_238 bb;

    protected final Vector3f minPosTemp1 = new Vector3f();
    protected final Vector3f maxPosTemp1 = new Vector3f();

    protected final Vector4f colorTemp1 = new Vector4f();
    protected final Vector3f pos0Temp = new Vector3f();
    protected final Vector3f pos1Temp = new Vector3f();
    protected final Vector3f pos2Temp = new Vector3f();
    protected final Vector3f pos3Temp = new Vector3f();
    protected final Vector3f normalTemp = new Vector3f();
    protected final Vector3f originTemp = new Vector3f();

    public AABBOutline(class_238 bb) {
        setBounds(bb);
    }

    public class_238 getBounds() {
        return bb;
    }

    public void setBounds(class_238 bb) {
        this.bb = bb;
    }

    @Override
    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        params.loadColor(colorTemp);
        Vector4f color = colorTemp;
        int lightmap = params.lightmap;
        boolean disableLineNormals = params.disableLineNormals;
        renderBox(ms, buffer, camera, bb, color, lightmap, disableLineNormals);
    }

    protected void renderBox(
        class_4587 ms,
        SuperRenderTypeBuffer buffer,
        class_243 camera,
        class_238 box,
        Vector4f color,
        int lightmap,
        boolean disableLineNormals
    ) {
        Vector3f minPos = minPosTemp1;
        Vector3f maxPos = maxPosTemp1;

        boolean cameraInside = box.method_1006(camera);
        boolean cull = !cameraInside && !params.disableCull;
        float inflate = cameraInside ? -1 / 128f : 1 / 128f;

        box = box.method_997(camera.method_1021(-1));
        minPos.set((float) box.field_1323 - inflate, (float) box.field_1322 - inflate, (float) box.field_1321 - inflate);
        maxPos.set((float) box.field_1320 + inflate, (float) box.field_1325 + inflate, (float) box.field_1324 + inflate);

        renderBoxFaces(ms, buffer, cull, params.getHighlightedFace(), minPos, maxPos, color, lightmap);

        float lineWidth = params.getLineWidth();
        if (lineWidth == 0)
            return;

        class_4588 consumer = buffer.method_73477(PonderRenderTypes.outlineSolid());
        renderBoxEdges(ms, consumer, minPos, maxPos, lineWidth, color, lightmap, disableLineNormals);
    }

    protected void renderBoxFaces(
        class_4587 ms,
        SuperRenderTypeBuffer buffer,
        boolean cull,
        class_2350 highlightedFace,
        Vector3f minPos,
        Vector3f maxPos,
        Vector4f color,
        int lightmap
    ) {
        class_4587.class_4665 pose = ms.method_23760();
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11033, color, lightmap);
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11036, color, lightmap);
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11043, color, lightmap);
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11035, color, lightmap);
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11039, color, lightmap);
        renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11034, color, lightmap);
    }

    protected void renderBoxFace(
        class_4587.class_4665 pose,
        SuperRenderTypeBuffer buffer,
        boolean cull,
        class_2350 highlightedFace,
        Vector3f minPos,
        Vector3f maxPos,
        class_2350 face,
        Vector4f color,
        int lightmap
    ) {
        boolean highlighted = face == highlightedFace;

        // TODO: Presumably, the other texture should be used, but this was not noticed before so fixing it may lead to suboptimal visuals.
        //BindableTexture faceTexture = highlighted ? params.hightlightedFaceTexture : params.faceTexture;
        BindableTexture faceTexture = params.faceTexture;
        if (faceTexture == null)
            return;

        class_1921 renderType = PonderRenderTypes.outlineTranslucent(faceTexture.getLocation(), cull);
        class_4588 consumer = buffer.getLateBuffer(renderType);

        float alphaMult = highlighted ? 1 : 0.5f;
        colorTemp1.set(color.x(), color.y(), color.z(), color.w() * alphaMult);
        color = colorTemp1;

        renderBoxFace(pose, consumer, minPos, maxPos, face, color, lightmap);
    }

    protected void renderBoxFace(
        class_4587.class_4665 pose,
        class_4588 consumer,
        Vector3f minPos,
        Vector3f maxPos,
        class_2350 face,
        Vector4f color,
        int lightmap
    ) {
        Vector3f pos0 = pos0Temp;
        Vector3f pos1 = pos1Temp;
        Vector3f pos2 = pos2Temp;
        Vector3f pos3 = pos3Temp;
        Vector3f normal = normalTemp;

        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();

        float maxU;
        float maxV;

        switch (face) {
            case field_11033 -> {
                // 0 1 2 3
                pos0.set(minX, minY, maxZ);
                pos1.set(minX, minY, minZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, minY, maxZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0, -1, 0);
            }
            case field_11036 -> {
                // 4 5 6 7
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, maxY, maxZ);
                pos2.set(maxX, maxY, maxZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0, 1, 0);
            }
            case field_11043 -> {
                // 7 2 1 4
                pos0.set(maxX, maxY, minZ);
                pos1.set(maxX, minY, minZ);
                pos2.set(minX, minY, minZ);
                pos3.set(minX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0, 0, -1);
            }
            case field_11035 -> {
                // 5 0 3 6
                pos0.set(minX, maxY, maxZ);
                pos1.set(minX, minY, maxZ);
                pos2.set(maxX, minY, maxZ);
                pos3.set(maxX, maxY, maxZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0, 0, 1);
            }
            case field_11039 -> {
                // 4 1 0 5
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, minY, minZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, maxY, maxZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(-1, 0, 0);
            }
            case field_11034 -> {
                // 6 3 2 7
                pos0.set(maxX, maxY, maxZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(1, 0, 0);
            }
            default -> {
                maxU = 1;
                maxV = 1;
            }
        }

        bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0, 0, maxU, maxV, lightmap, normal);
    }

    protected void renderBoxEdges(
        class_4587 ms,
        class_4588 consumer,
        Vector3f minPos,
        Vector3f maxPos,
        float lineWidth,
        Vector4f color,
        int lightmap,
        boolean disableNormals
    ) {
        Vector3f origin = originTemp;

        class_4587.class_4665 pose = ms.method_23760();

        float lineLengthX = maxPos.x() - minPos.x();
        float lineLengthY = maxPos.y() - minPos.y();
        float lineLengthZ = maxPos.z() - minPos.z();

        origin.set(minPos);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);

        origin.set(maxPos.x(), minPos.y(), minPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);

        origin.set(minPos.x(), maxPos.y(), minPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);

        origin.set(minPos.x(), minPos.y(), maxPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);

        origin.set(minPos.x(), maxPos.y(), maxPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);

        origin.set(maxPos.x(), minPos.y(), maxPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);

        origin.set(maxPos.x(), maxPos.y(), minPos.z());
        bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);
    }

}
