package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.SortedMap;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_12249;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_750;
import net.minecraft.class_9799;

public class DefaultSuperRenderTypeBuffer implements SuperRenderTypeBuffer {

    private static final DefaultSuperRenderTypeBuffer INSTANCE = new DefaultSuperRenderTypeBuffer();

    public static DefaultSuperRenderTypeBuffer getInstance() {
        return INSTANCE;
    }

    protected SuperRenderTypeBufferPhase earlyBuffer;
    protected SuperRenderTypeBufferPhase defaultBuffer;
    protected SuperRenderTypeBufferPhase lateBuffer;

    public DefaultSuperRenderTypeBuffer() {
        earlyBuffer = new SuperRenderTypeBufferPhase();
        defaultBuffer = new SuperRenderTypeBufferPhase();
        lateBuffer = new SuperRenderTypeBufferPhase();
    }

    @Override
    public class_4588 getEarlyBuffer(class_1921 type) {
        return earlyBuffer.bufferSource.method_73477(type);
    }

    @Override
    public class_4588 method_73477(class_1921 type) {
        return defaultBuffer.bufferSource.method_73477(type);
    }

    @Override
    public class_4588 getLateBuffer(class_1921 type) {
        return lateBuffer.bufferSource.method_73477(type);
    }

    @Override
    public void draw() {
        earlyBuffer.bufferSource.method_22993();
        defaultBuffer.bufferSource.method_22993();
        lateBuffer.bufferSource.method_22993();
    }

    @Override
    public void draw(class_1921 type) {
        earlyBuffer.bufferSource.method_22994(type);
        defaultBuffer.bufferSource.method_22994(type);
        lateBuffer.bufferSource.method_22994(type);
    }

    public static class SuperRenderTypeBufferPhase {
        // Visible clones from RenderBuffers
        private final class_750 fixedBufferPack = new class_750();
        private final SortedMap<class_1921, class_9799> fixedBuffers = class_156.method_654(
            new Object2ObjectLinkedOpenHashMap<>(), map -> {
                map.put(class_4722.method_24073(), fixedBufferPack.method_3154(class_11515.field_60923));
                map.put(class_4722.method_24074(), fixedBufferPack.method_3154(class_11515.field_60925));
                map.put(class_4722.method_29382(), fixedBufferPack.method_3154(class_11515.field_60926));
                put(map, class_4722.method_76545());
                put(map, class_4722.method_24067());
                put(map, class_4722.method_24069());
                put(map, class_4722.method_24070());
                put(map, class_4722.method_24071());
                put(map, class_4722.method_45783());
                map.put(class_4722.method_24072(), new class_9799(786432));
                put(map, class_12249.method_75989());
                put(map, class_12249.method_75995());
                put(map, class_12249.method_75993());
                put(map, class_12249.method_75997());
                put(map, class_12249.method_75985());
                class_1088.field_21772.forEach(renderType -> put(map, renderType));

                //extras
                put(map, PonderRenderTypes.outlineSolid());
                put(map, CreateRenderTypes.translucent());
                put(map, CreateRenderTypes.additive());
            }
        );
        private final class_4598 bufferSource = class_4597.method_22992(fixedBuffers, new class_9799(256));

        private static void put(Object2ObjectLinkedOpenHashMap<class_1921, class_9799> map, class_1921 type) {
            map.put(type, new class_9799(type.method_22722()));
        }

    }
}
