package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import net.minecraft.class_1058;
import net.minecraft.class_12249;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_9326;

public class FluidRenderHelper {
    public static void renderFluidBox(
        class_3611 fluid,
        class_9326 changes,
        float xMin,
        float yMin,
        float zMin,
        float xMax,
        float yMax,
        float zMax,
        class_4597 buffer,
        class_4587 ms,
        int light,
        boolean renderBottom,
        boolean invertGasses
    ) {
        renderFluidBox(
            fluid,
            changes,
            xMin,
            yMin,
            zMin,
            xMax,
            yMax,
            zMax,
            buffer.method_73477(class_12249.method_75977()),
            ms,
            light,
            renderBottom,
            invertGasses
        );
    }

    public static void renderFluidBox(
        class_3611 fluid,
        class_9326 changes,
        float xMin,
        float yMin,
        float zMin,
        float xMax,
        float yMax,
        float zMax,
        class_4588 builder,
        class_4587 ms,
        int light,
        boolean renderBottom,
        boolean invertGasses
    ) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 fluidTexture = config.still().get();

        int color = config.tint().apply(changes) | 0xff000000;
        int blockLightIn = (light >> 4) & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = (light & 0xF00000) | luminosity << 4;

        class_243 center = new class_243(xMin + (xMax - xMin) / 2, yMin + (yMax - yMin) / 2, zMin + (zMax - zMin) / 2);
        ms.method_22903();
        //TODO
        if (invertGasses && false) {
            ms.method_22904(center.field_1352, center.field_1351, center.field_1350);
            ms.method_22907(class_7833.field_40714.rotationDegrees(180));
            ms.method_22904(-center.field_1352, -center.field_1351, -center.field_1350);
        }

        class_4587.class_4665 entry = ms.method_23760();
        for (class_2350 side : Iterate.directions) {
            if (side == class_2350.field_11033 && !renderBottom)
                continue;

            boolean positive = side.method_10171() == class_2350.class_2352.field_11056;
            if (side.method_10166().method_10179()) {
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, entry, light, color, fluidTexture);
                } else {
                    renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, entry, light, color, fluidTexture);
                }
            } else {
                renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, entry, light, color, fluidTexture);
            }
        }

        ms.method_22909();
    }

    public static void renderFluidBox(
        class_3611 fluid,
        class_9326 changes,
        float xMin,
        float yMin,
        float zMin,
        float xMax,
        float yMax,
        float zMax,
        class_4588 builder,
        class_4587.class_4665 entry,
        int light,
        boolean renderBottom,
        boolean invertGasses
    ) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 fluidTexture = config.still().get();

        int color = config.tint().apply(changes) | 0xff000000;
        int blockLightIn = (light >> 4) & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = (light & 0xF00000) | luminosity << 4;

        class_243 center = new class_243(xMin + (xMax - xMin) / 2, yMin + (yMax - yMin) / 2, zMin + (zMax - zMin) / 2);
        //TODO
        if (invertGasses && false) {
            entry.method_67796((float) center.field_1352, (float) center.field_1351, (float) center.field_1350);
            entry.method_67798(class_7833.field_40714.rotationDegrees(180));
            entry.method_67796((float) -center.field_1352, (float) -center.field_1351, (float) -center.field_1350);
        }

        for (class_2350 side : Iterate.directions) {
            if (side == class_2350.field_11033 && !renderBottom)
                continue;

            boolean positive = side.method_10171() == class_2350.class_2352.field_11056;
            if (side.method_10166().method_10179()) {
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, entry, light, color, fluidTexture);
                } else {
                    renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, entry, light, color, fluidTexture);
                }
            } else {
                renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, entry, light, color, fluidTexture);
            }
        }
    }

    public static void renderStillTiledFace(
        class_2350 dir,
        float left,
        float down,
        float right,
        float up,
        float depth,
        class_4588 builder,
        class_4587.class_4665 entry,
        int light,
        int color,
        class_1058 texture
    ) {
        renderTiledFace(dir, left, down, right, up, depth, builder, entry, light, color, texture, 1);
    }

    public static void renderTiledFace(
        class_2350 dir,
        float left,
        float down,
        float right,
        float up,
        float depth,
        class_4588 builder,
        class_4587.class_4665 entry,
        int light,
        int color,
        class_1058 texture,
        float textureScale
    ) {
        boolean positive = dir.method_10171() == class_2350.class_2352.field_11056;
        boolean horizontal = dir.method_10166().method_10179();
        boolean x = dir.method_10166() == class_2350.class_2351.field_11048;

        float f;
        float x2;
        float y2;
        float u1, u2;
        float v1, v2;
        for (float x1 = left; x1 < right; x1 = x2) {
            f = class_3532.method_15375(x1);
            x2 = Math.min(f + 1, right);
            if (dir == class_2350.field_11043 || dir == class_2350.field_11034) {
                f = class_3532.method_15386(x2);
                u1 = texture.method_4580((f - x2) * textureScale);
                u2 = texture.method_4580((f - x1) * textureScale);
            } else {
                u1 = texture.method_4580((x1 - f) * textureScale);
                u2 = texture.method_4580((x2 - f) * textureScale);
            }
            for (float y1 = down; y1 < up; y1 = y2) {
                f = class_3532.method_15375(y1);
                y2 = Math.min(f + 1, up);
                if (dir == class_2350.field_11036) {
                    v1 = texture.method_4570((y1 - f) * textureScale);
                    v2 = texture.method_4570((y2 - f) * textureScale);
                } else {
                    f = class_3532.method_15386(y2);
                    v1 = texture.method_4570((f - y2) * textureScale);
                    v2 = texture.method_4570((f - y1) * textureScale);
                }

                if (horizontal) {
                    if (x) {
                        putVertex(builder, entry, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        putVertex(builder, entry, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        putVertex(builder, entry, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        putVertex(builder, entry, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        putVertex(builder, entry, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        putVertex(builder, entry, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        putVertex(builder, entry, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        putVertex(builder, entry, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    putVertex(builder, entry, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    putVertex(builder, entry, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    putVertex(builder, entry, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    putVertex(builder, entry, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
            }
        }
    }

    protected static void putVertex(
        class_4588 builder,
        class_4587.class_4665 entry,
        float x,
        float y,
        float z,
        int color,
        float u,
        float v,
        class_2350 face,
        int light
    ) {

        class_2382 normal = face.method_62675();
        int a = color >> 24 & 0xff;
        int r = color >> 16 & 0xff;
        int g = color >> 8 & 0xff;
        int b = color & 0xff;

        builder.method_22918(entry.method_23761(), x, y, z).method_1336(r, g, b, a).method_22913(u, v)
            //.overlayCoords(OverlayTexture.NO_OVERLAY)
            .method_60803(light).method_60831(entry, normal.method_10263(), normal.method_10264(), normal.method_10260());
    }

}