package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.ponder.enums.PonderSpecialTextures;
import java.util.function.BiFunction;
import net.minecraft.class_10799;
import net.minecraft.class_12246;
import net.minecraft.class_12247;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

import static com.zurrtum.create.client.ponder.Ponder.MOD_ID;

public class PonderRenderTypes {
    private static final class_1921 GUI = class_1921.method_75940(
        createLayerName("gui"),
        class_12247.method_75927(class_10799.field_56879).method_75929(786432).method_75938()
    );

    private static final class_1921 OUTLINE_SOLID = class_1921.method_75940(
        createLayerName("outline_solid"),
        class_12247.method_75927(class_10799.field_56901).method_75929(256).method_75934("Sampler0", PonderSpecialTextures.BLANK.getLocation())
            .method_75928().method_75935().method_75938()
    );

    private static final BiFunction<class_2960, Boolean, class_1921> OUTLINE_TRANSLUCENT = class_156.method_34865((texture, cull) -> class_1921.method_75940(
        createLayerName("outline_translucent" + (cull ? "_cull" : "")),
        class_12247.method_75927(cull ? PonderRenderPipelines.RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL : PonderRenderPipelines.ENTITY_TRANSLUCENT)
            .method_75929(256).method_75937().method_75934("Sampler0", texture).method_75928().method_75935()
            .method_75931(class_12246.field_63983).method_75938()
    ));

    public static class_1921 getGui() {
        return GUI;
    }

    public static class_1921 outlineSolid() {
        return OUTLINE_SOLID;
    }

    public static class_1921 outlineTranslucent(class_2960 texture, boolean cull) {
        return OUTLINE_TRANSLUCENT.apply(texture, cull);
    }

    private static String createLayerName(String name) {
        return MOD_ID + ":" + name;
    }
}
