package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.compat.jei.renderer.JunkSlotRenderer;
import com.zurrtum.create.client.compat.jei.renderer.SlotRenderer;
import com.zurrtum.create.client.compat.jei.widget.ChanceTooltip;
import com.zurrtum.create.client.compat.jei.widget.PotionTooltip;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_6885;
import net.minecraft.class_9326;
import java.util.ArrayList;
import java.util.List;

public abstract class CreateCategory<T> implements IRecipeCategory<T> {
    public static final SlotRenderer EMPTY = new SlotRenderer(null, 18, 18);
    public static final SlotRenderer SLOT = new SlotRenderer(AllGuiTextures.JEI_SLOT);
    public static final SlotRenderer CHANCE_SLOT = new SlotRenderer(AllGuiTextures.JEI_CHANCE_SLOT);
    public static final PotionTooltip POTION = new PotionTooltip();

    public static List<class_1799> getStacks(SizedIngredient ingredient) {
        int count = ingredient.getCount();
        return ingredient.getIngredient().field_9019.method_40239().map(entry -> new class_1799(entry, count)).toList();
    }

    public static List<class_1799> getStacks(class_1856 ingredient) {
        return ingredient.field_9019.method_40239().map(class_1799::new).toList();
    }

    public static List<List<class_1799>> condenseIngredients(List<class_1856> ingredients) {
        List<class_1799> cache = new ArrayList<>();
        List<List<class_1799>> result = new ArrayList<>();
        Find:
        for (class_1856 ingredient : ingredients) {
            class_6885<class_1792> entries = ingredient.field_9019;
            if (entries.method_40247() != 1) {
                result.add(getStacks(ingredient));
                continue;
            }
            class_1792 item = entries.method_40240(0).comp_349();
            for (class_1799 target : cache) {
                if (target.method_31574(item)) {
                    target.method_7933(1);
                    continue Find;
                }
            }
            class_1799 stack = item.method_7854();
            cache.add(stack);
            result.add(List.of(stack));
        }
        return result;
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidStack stack) {
        int amount = stack.getAmount();
        IRecipeSlotBuilder slot = builder.addOutputSlot(x, y).setFluidRenderer(amount, false, 16, 16)
            .add(stack.getFluid(), amount, stack.getComponentChanges());
        if (stack.isOf(AllFluids.POTION)) {
            slot.addRichTooltipCallback(POTION);
        }
        return slot;
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidIngredient fluidIngredient) {
        int amount = fluidIngredient.amount();
        IRecipeSlotBuilder slot = builder.addInputSlot(x, y).setFluidRenderer(amount, false, 16, 16);
        class_9326 components = class_9326.field_49588;
        if (fluidIngredient instanceof FluidStackIngredient stackIngredient) {
            components = stackIngredient.components();
        }
        boolean ignorePotion = true;
        for (class_3611 fluid : fluidIngredient.getMatchingFluids()) {
            slot.add(fluid, amount, components);
            if (ignorePotion && fluid == AllFluids.POTION) {
                ignorePotion = false;
            }
        }
        if (ignorePotion) {
            return slot;
        }
        return slot.addRichTooltipCallback(POTION);
    }

    public static void addChanceSlot(IRecipeLayoutBuilder builder, int x, int y, ChanceOutput output) {
        IRecipeSlotBuilder slot = builder.addOutputSlot(x, y).add(output.stack());
        if (output.chance() == 1) {
            slot.setBackground(SLOT, -1, -1);
        } else {
            slot.setBackground(CHANCE_SLOT, -1, -1).addRichTooltipCallback(new ChanceTooltip(output));
        }
    }

    public static void addJunkSlot(IRecipeLayoutBuilder builder, int x, int y, float chance) {
        JunkSlotRenderer.addSlot(builder, x, y, chance);
    }

    @Override
    public int getWidth() {
        return 177;
    }
}
