package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.MixingBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1867;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;

public class AutoMixingCategory extends CreateCategory<class_8786<class_1867>> {
    @SuppressWarnings("unchecked")
    public static List<class_8786<class_1867>> getRecipes(class_10289 preparedRecipes) {
        List<class_8786<class_1867>> recipes = new ArrayList<>();
        for (class_8786<class_3955> entry : preparedRecipes.method_64698(class_3956.field_17545)) {
            class_3955 recipe = entry.comp_1933();
            if (!(recipe instanceof class_1867 shapelessRecipe) || MechanicalPressBlockEntity.canCompress(shapelessRecipe) || AllRecipeTypes.shouldIgnoreInAutomation(
                entry) || shapelessRecipe.field_9047.size() == 1) {
                continue;
            }
            recipes.add((class_8786<class_1867>) (Object) entry);
        }
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<class_1867>> getRecipeType() {
        return JeiClientPlugin.AUTOMATIC_SHAPELESS;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.automatic_shapeless");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.MECHANICAL_MIXER, class_1802.field_8465);
    }

    @Override
    public int getHeight() {
        return 85;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_1867> entry, IFocusGroup focuses) {
        class_1867 recipe = entry.comp_1933();
        List<List<class_1799>> ingredients = condenseIngredients(recipe.field_9047);
        for (int i = 0, size = ingredients.size(), xOffset = size < 3 ? (3 - size) * 19 / 2 : 0; i < size; i++) {
            builder.addInputSlot(12 + xOffset + (i % 3) * 19, 51 - (i / 3) * 19).setBackground(SLOT, -1, -1).addItemStacks(ingredients.get(i));
        }
        builder.addOutputSlot(142, 51).setBackground(SLOT, -1, -1).add(recipe.field_9050);
    }

    @Override
    public void draw(class_8786<class_1867> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 32);
        AllGuiTextures.JEI_SHADOW.render(graphics, 81, 68);
        graphics.field_59826.method_70922(new MixingBasinRenderState(new Matrix3x2f(graphics.method_51448()), 91, -5));
    }
}
