package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.IconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.ManualBlockRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1747;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.List;

public class ManualApplicationCategory extends CreateCategory<class_8786<ManualApplicationRecipe>> {
    public static List<class_8786<ManualApplicationRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.ITEM_APPLICATION).stream().toList();
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<ManualApplicationRecipe>> getRecipeType() {
        return JeiClientPlugin.ITEM_APPLICATION;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.item_application");
    }

    @Override
    public IDrawable getIcon() {
        return new IconRenderer(AllItems.BRASS_HAND);
    }

    @Override
    public int getHeight() {
        return 60;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<ManualApplicationRecipe> entry, IFocusGroup focuses) {
        ManualApplicationRecipe recipe = entry.comp_1933();
        builder.addInputSlot(51, 5).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        builder.addInputSlot(27, 38).setSlotName("target").setBackground(SLOT, -1, -1).add(recipe.target());
        builder.addOutputSlot(132, 38).setBackground(SLOT, -1, -1).add(recipe.result());
    }

    @Override
    public void draw(
        class_8786<ManualApplicationRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 67, 52);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 79, 15);
        recipeSlotsView.findSlotByName("target").flatMap(IRecipeSlotView::getDisplayedItemStack).ifPresent(stack -> {
            if (stack.method_7909() instanceof class_1747 blockItem) {
                class_2680 block = blockItem.method_7711().method_9564();
                graphics.field_59826.method_70922(new ManualBlockRenderState(new Matrix3x2f(graphics.method_51448()), block, 79, 34));
            }
        });
    }
}
