package com.zurrtum.create.client.compat.jei.category;

import com.mojang.datafixers.util.Either;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.IconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.zurrtum.create.infrastructure.component.BottleType;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_10289;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SequencedAssemblyCategory extends CreateCategory<class_8786<SequencedAssemblyRecipe>> {
    public static String[] ROMANS = {"I", "II", "III", "IV", "V", "VI", "-"};
    public static Map<class_3956<?>, SequencedRenderer<?>> RENDER = new IdentityHashMap<>();

    static {
        registerRenderer(AllRecipeTypes.PRESSING, new PressingRenderer());
        registerRenderer(AllRecipeTypes.DEPLOYING, new DeployingRenderer());
        registerRenderer(AllRecipeTypes.FILLING, new FillingRenderer());
    }

    @SuppressWarnings("unchecked")
    public static <T extends class_1860<?>> SequencedRenderer<T> getRenderer(T recipe) {
        return (SequencedRenderer<T>) RENDER.get(recipe.method_17716());
    }

    public static <T extends class_1860<?>> void registerRenderer(class_3956<T> type, SequencedRenderer<T> draw) {
        RENDER.put(type, draw);
    }

    public static List<class_8786<SequencedAssemblyRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.SEQUENCED_ASSEMBLY).stream().toList();
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<SequencedAssemblyRecipe>> getRecipeType() {
        return JeiClientPlugin.SEQUENCED_ASSEMBLY;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.sequenced_assembly");
    }

    @Override
    public IDrawable getIcon() {
        return new IconRenderer(AllItems.PRECISION_MECHANISM);
    }

    @Override
    public int getHeight() {
        return 115;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<SequencedAssemblyRecipe> entry, IFocusGroup focuses) {
        SequencedAssemblyRecipe recipe = entry.comp_1933();
        ChanceOutput chanceOutput = recipe.result();
        boolean randomOutput = chanceOutput.chance() != 1;
        int xOffset = randomOutput ? -7 : 0;
        builder.addInputSlot(xOffset + 22, 91).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        addChanceSlot(builder, xOffset + 127, 91, chanceOutput);
        if (randomOutput) {
            addJunkSlot(builder, xOffset + 146, 91, 1 - chanceOutput.chance());
        }
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        for (int i = 0, left = 94 - 14 * size; i < size; i++) {
            addSlot(builder, left + i * 28, recipes.get(i), i);
        }
    }

    private static <T extends class_1860<?>> void addSlot(IRecipeLayoutBuilder builder, int x, T sequence, int i) {
        SequencedRenderer<T> renderer = getRenderer(sequence);
        if (renderer != null) {
            IRecipeSlotBuilder slot = renderer.addSlot(builder, x, 15, sequence);
            if (slot != null) {
                slot.addRichTooltipCallback(new SequenceTooltip<>(renderer, sequence, i)).setSlotName(String.valueOf(i));
            }
        }
    }

    @Override
    public void draw(
        class_8786<SequencedAssemblyRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        SequencedAssemblyRecipe recipe = entry.comp_1933();
        ChanceOutput chanceOutput = recipe.result();
        boolean randomOutput = chanceOutput.chance() != 1;
        int xOffset = randomOutput ? -7 : 0;
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        class_327 textRenderer = graphics.field_44656.field_1772;
        for (int i = 0, left = 94 - 14 * size; i < size; i++) {
            int x = left + i * 28;
            String text = ROMANS[Math.min(i, ROMANS.length)];
            Optional<IRecipeSlotView> slot = recipeSlotsView.findSlotByName(String.valueOf(i));
            if (slot.isPresent()) {
                AllGuiTextures.JEI_SLOT.render(graphics, x - 1, 14);
            }
            graphics.method_51433(textRenderer, text, x + 8 - textRenderer.method_1727(text) / 2, 2, 0xff888888, false);
            SequencedRenderer<?> draw = getRenderer(recipes.get(i));
            if (draw != null) {
                draw.render(graphics, i, x, 15, slot);
            }
        }
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, xOffset + 47, 94);
        if (recipe.loops() > 1) {
            AllIcons.I_SEQ_REPEAT.render(graphics, xOffset + 60, 99);
            class_2561 repeat = class_2561.method_43470("x" + recipe.loops());
            graphics.method_51439(textRenderer, repeat, xOffset + 76, 104, 0xff888888, false);
        }
    }

    @Override
    public void getTooltip(
        ITooltipBuilder tooltip,
        class_8786<SequencedAssemblyRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        double mouseX,
        double mouseY
    ) {
        SequencedAssemblyRecipe recipe = entry.comp_1933();
        if (recipe.loops() > 1 && mouseX >= 43 && mouseX < 108 && mouseY >= 92 && mouseY < 116) {
            tooltip.add(CreateLang.translateDirect("recipe.assembly.repeat", recipe.loops()));
            return;
        }
        if (mouseY < 5 || mouseY > 84) {
            return;
        }
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        for (int i = 0, left = 88 - 14 * size; i < size; i++) {
            int x = left + i * 28;
            if (x <= mouseX && x + 28 > mouseX) {
                onRichTooltip(tooltip, recipes.get(i), recipeSlotsView, i);
                break;
            }
        }
    }

    private static <T extends class_1860<?>> void onRichTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, int i) {
        tooltip.add(SequenceTooltip.getStep(i));
        SequencedRenderer<T> renderer = getRenderer(recipe);
        if (renderer == null) {
            return;
        }
        tooltip.add(SequenceTooltip.getSequenceName(renderer, recipe, recipeSlotsView.findSlotByName(String.valueOf(i))));
    }

    public interface SequencedRenderer<T extends class_1860<?>> {
        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot);

        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        default class_2561 getSequenceName(T recipe, Optional<IRecipeSlotView> slot) {
            class_2960 id = class_7923.field_41188.method_10221(recipe.method_17716());
            if (id != null) {
                String namespace = id.method_12836();
                String recipeName;
                if (namespace.equals("create")) {
                    recipeName = id.method_12832();
                } else {
                    recipeName = id.method_12836() + "." + id.method_12832();
                }
                return class_2561.method_43471("create.recipe.assembly." + recipeName);
            }
            return class_5244.field_39003;
        }

        default IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, T recipe) {
            return null;
        }
    }

    public static class PressingRenderer implements SequencedRenderer<PressingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            float scale = 19 / 30f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate(x, y);
            matrices.scale(scale, scale);
            matrices.translate(-x, -y);
            graphics.field_59826.method_70922(new PressRenderState(i, new Matrix3x2f(matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }
    }

    public static class DeployingRenderer implements SequencedRenderer<DeployerApplicationRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            float scale = 59 / 78f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate(x, y);
            matrices.scale(scale, scale);
            matrices.translate(-x, -y);
            graphics.field_59826.method_70922(new DeployerRenderState(i, new Matrix3x2f(matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }

        @Override
        public class_2561 getSequenceName(DeployerApplicationRecipe recipe, Optional<IRecipeSlotView> slot) {
            class_2561 name = slot.flatMap(IRecipeSlotView::getDisplayedItemStack).map(class_1799::method_7964).orElse(class_5244.field_39003);
            return class_2561.method_43469("create.recipe.assembly.deploying_item", name);
        }

        @Override
        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, DeployerApplicationRecipe recipe) {
            return builder.addInputSlot(x, y).setBackground(EMPTY, 0, 0).add(recipe.ingredient());
        }
    }

    public static class FillingRenderer implements SequencedRenderer<FillingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            slot.flatMap(s -> s.getDisplayedIngredient(FabricTypes.FLUID_STACK)).ifPresent(ingredient -> {
                float scale = 35 / 46f;
                Matrix3x2fStack matrices = graphics.method_51448();
                matrices.pushMatrix();
                matrices.translate(x, y);
                matrices.scale(scale, scale);
                matrices.translate(-x, -y);
                FluidVariant fluidVariant = ingredient.getFluidVariant();
                class_3611 fluid = fluidVariant.getFluid();
                class_9326 components = fluidVariant.getComponents();
                graphics.field_59826.method_70922(new SpoutRenderState(
                    i,
                    new Matrix3x2f(matrices),
                    fluid,
                    components,
                    x - 2,
                    y + 24,
                    i
                ));
                matrices.popMatrix();
            });
        }

        @Override
        public class_2561 getSequenceName(FillingRecipe recipe, Optional<IRecipeSlotView> slot) {
            class_2561 name = slot.flatMap(s -> s.getDisplayedIngredient(FabricTypes.FLUID_STACK)).map(ingredient -> {
                FluidVariant fluidVariant = ingredient.getFluidVariant();
                class_3611 fluid = fluidVariant.getFluid();
                if (fluid == AllFluids.POTION) {
                    class_9323 components = fluidVariant.getComponentMap();
                    class_1844 contents = components.method_58695(class_9334.field_49651, class_1844.field_49274);
                    BottleType bottleType = components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, BottleType.REGULAR);
                    class_1935 itemFromBottleType = PotionFluidHandler.itemFromBottleType(bottleType);
                    return contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
                }
                class_2248 block = fluid.method_15785().method_15759().method_26204();
                if (fluid != class_3612.field_15906 && block == class_2246.field_10124) {
                    return class_2561.method_43471(class_156.method_646("block", class_7923.field_41173.method_10221(fluid)));
                }
                return block.method_9518();
            }).orElse(class_5244.field_39003);
            return class_2561.method_43469("create.recipe.assembly.spout_filling_fluid", name);
        }

        @Override
        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, FillingRecipe recipe) {
            return addFluidSlot(builder, x, y, recipe.fluidIngredient());
        }
    }

    public record SequenceTooltip<T extends class_1860<?>>(SequencedRenderer<T> renderer, T recipe, int i) implements IRecipeSlotRichTooltipCallback {
        public static class_2561 getStep(int i) {
            return CreateLang.translateDirect("recipe.assembly.step", i + 1);
        }

        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        public static <T extends class_1860<?>> class_2561 getSequenceName(SequencedRenderer<T> renderer, T recipe, Optional<IRecipeSlotView> slot) {
            return renderer.getSequenceName(recipe, slot).method_27661().method_27692(class_124.field_1077);
        }

        @Override
        public void onRichTooltip(IRecipeSlotView slot, ITooltipBuilder tooltip) {
            List<Either<class_5348, class_5632>> lines = tooltip.getLines();
            if (!lines.isEmpty()) {
                lines.removeFirst();
            }
            lines.addAll(0, List.of(Either.left(getStep(i)), Either.left(getSequenceName(renderer, recipe, Optional.of(slot)))));
        }
    }
}
