package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.BottleFluidInventory;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_10289;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

import static com.zurrtum.create.Create.MOD_ID;

public class SpoutFillingCategory extends CreateCategory<class_8786<FillingRecipe>> {
    public static final int MAX = 3;
    public static AtomicInteger idGenerator = new AtomicInteger();

    public static List<class_8786<FillingRecipe>> getRecipes(
        class_10289 preparedRecipes,
        Stream<class_1799> itemStream,
        Stream<IJeiFluidIngredient> fluidStream
    ) {
        List<class_8786<FillingRecipe>> recipes = new ArrayList<>(preparedRecipes.method_64698(AllRecipeTypes.FILLING));
        List<FluidStack> fluids = fluidStream.map(ingredient -> {
            FluidVariant variant = ingredient.getFluidVariant();
            return new FluidStack(variant.getFluid(), ingredient.getAmount(), variant.getComponents());
        }).toList();
        MutableInt i = new MutableInt();
        itemStream.forEach(stack -> {
            if (PotionFluidHandler.isPotionItem(stack)) {
                class_1844 potion = stack.method_58695(class_9334.field_49651, class_1844.field_49274);
                BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(stack.method_7909());
                recipes.add(new class_8786<>(
                    class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(MOD_ID, "filling_potions_" + i.getAndIncrement())),
                    new FillingRecipe(
                        stack,
                        class_1856.method_8101(class_1802.field_8469),
                        PotionFluidHandler.getFluidIngredientFromPotion(potion, bottleType, BottleFluidInventory.CAPACITY)
                    )
                ));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972())) {
                if (capability == null) {
                    return;
                }
                int size = capability.size();
                FluidStack existingFluid = size == 1 ? capability.getStack(0) : FluidStack.EMPTY;
                for (FluidStack fluid : fluids) {
                    if (size == 1 && !existingFluid.isEmpty() && !FluidStack.areFluidsAndComponentsEqual(existingFluid, fluid)) {
                        continue;
                    }
                    int insert = capability.insert(fluid, BucketFluidInventory.CAPACITY);
                    if (insert == 0) {
                        continue;
                    }
                    class_1799 result = capability.getContainer();
                    if (!result.method_7960()) {
                        class_1792 item = stack.method_7909();
                        if (!result.method_31574(item)) {
                            class_2960 itemName = class_7923.field_41178.method_10221(item);
                            class_2960 fluidName = class_7923.field_41173.method_10221(fluid.getFluid());
                            class_2960 id = class_2960.method_60655(
                                MOD_ID,
                                "fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()
                            );
                            class_1856 ingredient = stack.method_57380()
                                .method_57848() ? class_1856.method_8101(stack.method_7909()) : DefaultCustomIngredients.components(stack);
                            recipes.add(new class_8786<>(
                                class_5321.method_29179(class_7924.field_52178, id),
                                new FillingRecipe(result, ingredient, new FluidStackIngredient(fluid.getFluid(), fluid.getComponentChanges(), insert))
                            ));
                        }
                    }
                    capability.extract(fluid, insert);
                }
            }
        });
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<FillingRecipe>> getRecipeType() {
        return JeiClientPlugin.SPOUT_FILLING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.spout_filling");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.SPOUT, class_1802.field_8705);
    }

    @Override
    public int getHeight() {
        return 70;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<FillingRecipe> entry, IFocusGroup focuses) {
        FillingRecipe recipe = entry.comp_1933();
        builder.addInputSlot(27, 51).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        addFluidSlot(builder, 27, 32, recipe.fluidIngredient()).setBackground(SLOT, -1, -1).setSlotName("fluid");
        builder.addOutputSlot(132, 51).setBackground(SLOT, -1, -1).add(recipe.result());
    }

    @Override
    public void draw(class_8786<FillingRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        recipeSlotsView.findSlotByName("fluid").flatMap(view -> view.getDisplayedIngredient(FabricTypes.FLUID_STACK)).ifPresent(fluidIngredient -> {
            FluidVariant fluidVariant = fluidIngredient.getFluidVariant();
            int i = idGenerator.getAndIncrement();
            if (i >= MAX) {
                idGenerator.set(0);
            }
            graphics.field_59826.method_70922(new SpoutRenderState(
                i,
                new Matrix3x2f(graphics.method_51448()),
                fluidVariant.getFluid(),
                fluidVariant.getComponents(),
                75,
                1,
                0
            ));
        });
    }
}
