package com.zurrtum.create.client.compat.rei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.rei.CreateCategory;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.ManualBlockRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.compat.rei.display.ManualApplicationDisplay;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;

import java.util.List;

public class ManualApplicationCategory extends CreateCategory<ManualApplicationDisplay> {
    @Override
    public CategoryIdentifier<? extends ManualApplicationDisplay> getCategoryIdentifier() {
        return ReiCommonPlugin.ITEM_APPLICATION;
    }

    @Override
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.item_application");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of(AllItems.BRASS_HAND);
    }

    @Override
    public void addWidgets(List<Widget> widgets, ManualApplicationDisplay display, Rectangle bounds) {
        Point input = new Point(bounds.x + 56, bounds.y + 10);
        Point target = new Point(bounds.x + 32, bounds.y + 43);
        Point output = new Point(bounds.x + 137, bounds.y + 43);
        Slot targetSlot = createInputSlot(target).entries(display.target());
        widgets.add(Widgets.createDrawableWidget((class_332 graphics, int mouseX, int mouseY, float delta) -> {
            drawSlotBackground(graphics, input, target, output);
            AllGuiTextures.JEI_SHADOW.render(graphics, bounds.x + 67, bounds.y + 52);
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, bounds.x + 79, bounds.y + 15);
            EntryStack<class_1799> slot = targetSlot.getCurrentEntry().cast();
            class_1799 stack = slot.getValue();
            if (stack.method_7909() instanceof class_1747 blockItem) {
                class_2680 block = blockItem.method_7711().method_9564();
                graphics.field_59826.method_70922(new ManualBlockRenderState(
                    new Matrix3x2f(graphics.method_51448()),
                    block,
                    bounds.x + 79,
                    bounds.y + 34
                ));
            }
        }));
        widgets.add(createInputSlot(input).entries(display.input()));
        widgets.add(targetSlot);
        widgets.add(createOutputSlot(output).entries(display.output()));
    }

    @Override
    public int getDisplayHeight() {
        return 70;
    }
}
