package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RollerMovementRenderBehaviour implements MovementRenderBehaviour {
    @Nullable
    @Override
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new RollerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (VisualizationManager.supportsVisualization(context.world)) {
            return null;
        }
        RollerMovementRenderState state = new RollerMovementRenderState(context.localPos);
        state.layer = class_12249.method_75972();
        class_2680 blockState = context.state;
        class_2350 facing = blockState.method_11654(class_2741.field_12481);
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, blockState);
        float speed = !VecHelper.isVecPointingTowards(
            context.relativeMotion,
            facing.method_10153()
        ) ? context.getAnimationSpeed() : -context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0;
        }
        state.offset = class_243.method_24954(facing.method_62675()).method_1021(17 / 16f).method_1031(0, -0.25f, 0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        float time = AnimationTickHolder.getRenderTime(context.world) / 20;
        state.rotate = AngleHelper.rad((time * speed) % 360);
        state.light = class_761.method_23794(renderWorld, context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        state.yRot = class_3532.field_29847 * 90;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, blockState);
        state.frameAngle = AngleHelper.rad(angle + 180);
        return state;
    }

    public static class RollerMovementRenderState extends MovementRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer wheel;
        public class_243 offset;
        public float wheelAngle;
        public float rotate;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        public RollerMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            wheel.translate(offset).rotateCentered(wheelAngle, class_2350.field_11036).rotate(rotate, class_2350.field_11039).translate(0, -.5, .5).rotateY(yRot)
                .light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            frame.rotateCentered(frameAngle, class_2350.field_11036).light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
