package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class StabilizedBearingMovementRenderBehaviour implements MovementRenderBehaviour {
    @Nullable
    @Override
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new StabilizedBearingVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (VisualizationManager.supportsVisualization(context.world)) {
            return null;
        }
        StabilizedBearingMovementRenderState state = new StabilizedBearingMovementRenderState(context.localPos);
        state.layer = class_12249.method_75965();
        class_2350 facing = context.state.method_11654(class_2741.field_12525);
        state.top = CachedBuffers.partial(AllPartialModels.BEARING_TOP, context.state);
        // rotate to match blockstate
        Quaternionf orientation = BearingVisual.getBlockStateOrientation(facing);
        // rotate against parent
        float angle = getCounterRotationAngle(context, facing, AnimationTickHolder.getPartialTicks()) * facing.method_10171().method_10181();
        Quaternionf rotation = class_7833.method_46356(facing.method_23955()).rotationDegrees(angle);
        state.orientation = rotation.mul(orientation);
        state.light = class_761.method_23794(renderWorld, context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        return state;
    }

    static float getCounterRotationAngle(MovementContext context, class_2350 facing, float renderPartialTicks) {
        if (!context.contraption.canBeStabilized(facing, context.localPos))
            return 0;

        float offset = 0;
        class_2350.class_2351 axis = facing.method_10166();
        AbstractContraptionEntity entity = context.contraption.entity;

        if (entity instanceof ControlledContraptionEntity controlledCE) {
            if (context.contraption.canBeStabilized(facing, context.localPos))
                offset = -controlledCE.getAngle(renderPartialTicks);

        } else if (entity instanceof OrientedContraptionEntity orientedCE) {
            if (axis.method_10178())
                offset = -orientedCE.method_5705(renderPartialTicks);
            else {
                if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().method_10166() == axis)
                    offset = -orientedCE.method_5695(renderPartialTicks);
            }
        }
        return offset;
    }

    public static class StabilizedBearingMovementRenderState extends MovementRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer top;
        public Quaternionf orientation;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;

        public StabilizedBearingMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            top.rotateCentered(orientation).light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
