package com.zurrtum.create.client.content.contraptions.minecart;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import net.minecraft.class_12249;
import net.minecraft.class_1688;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9883;

public class CouplingRenderer {

    public static void renderAll(class_310 mc, class_4587 ms, class_4597 buffer, class_243 camera) {
        class_638 world = mc.field_1687;
        CouplingHandler.forEachLoadedCoupling(
            world, c -> {
                if (c.getFirst().hasContraptionCoupling(true))
                    return;
                CouplingRenderer.renderCoupling(world, ms, buffer, camera, c.map(MinecartController::cart));
            }
        );
    }

    public static void tickDebugModeRenders(class_310 mc) {
        if (KineticDebugger.isActive())
            CouplingHandler.forEachLoadedCoupling(mc.field_1687, CouplingRenderer::doDebugRender);
    }

    public static void renderCoupling(class_638 world, class_4587 ms, class_4597 buffer, class_243 camera, Couple<class_1688> carts) {
        if (carts.getFirst() == null || carts.getSecond() == null)
            return;

        Couple<Integer> lightValues = carts.map(c -> class_761.method_23794(world, class_2338.method_49638(c.method_5829().method_1005())));

        class_243 center = carts.getFirst().method_73189().method_1019(carts.getSecond().method_73189()).method_1021(.5f);

        Couple<CartEndpoint> transforms = carts.map(c -> getSuitableCartEndpoint(c, center));

        class_2680 renderState = class_2246.field_10124.method_9564();
        class_4588 builder = buffer.method_73477(class_12249.method_75965());
        SuperByteBuffer attachment = CachedBuffers.partial(AllPartialModels.COUPLING_ATTACHMENT, renderState);
        SuperByteBuffer ring = CachedBuffers.partial(AllPartialModels.COUPLING_RING, renderState);
        SuperByteBuffer connector = CachedBuffers.partial(AllPartialModels.COUPLING_CONNECTOR, renderState);

        class_243 zero = class_243.field_1353;
        class_243 firstEndpoint = transforms.getFirst().apply(zero);
        class_243 secondEndpoint = transforms.getSecond().apply(zero);
        class_243 endPointDiff = secondEndpoint.method_1020(firstEndpoint);
        double connectorYaw = -Math.atan2(endPointDiff.field_1350, endPointDiff.field_1352) * 180.0D / Math.PI;
        double connectorPitch = Math.atan2(endPointDiff.field_1351, endPointDiff.method_18805(1, 0, 1).method_1033()) * 180 / Math.PI;

        var msr = TransformStack.of(ms);
        carts.forEachWithContext((cart, isFirst) -> {
            CartEndpoint cartTransform = transforms.get(isFirst);

            ms.method_22903();
            cartTransform.apply(ms, camera);
            attachment.light(lightValues.get(isFirst)).renderInto(ms.method_23760(), builder);
            msr.rotateYDegrees((float) connectorYaw - cartTransform.yaw);
            ring.light(lightValues.get(isFirst)).renderInto(ms.method_23760(), builder);
            ms.method_22909();
        });

        int l1 = lightValues.getFirst();
        int l2 = lightValues.getSecond();
        int meanBlockLight = (((l1 >> 4) & 0xf) + ((l2 >> 4) & 0xf)) / 2;
        int meanSkyLight = (((l1 >> 20) & 0xf) + ((l2 >> 20) & 0xf)) / 2;

        ms.method_22903();
        msr.translate(firstEndpoint.method_1020(camera)).rotateYDegrees((float) connectorYaw).rotateZDegrees((float) connectorPitch);
        ms.method_22905((float) endPointDiff.method_1033(), 1, 1);

        connector.light(meanSkyLight << 20 | meanBlockLight << 4).renderInto(ms.method_23760(), builder);
        ms.method_22909();
    }

    private static CartEndpoint getSuitableCartEndpoint(class_1688 cart, class_243 centerOfCoupling) {
        long i = cart.method_5628() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        double x = (((float) (i >> 16 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        double y = (((float) (i >> 20 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F + 0.375F;
        double z = (((float) (i >> 24 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;

        float pt = AnimationTickHolder.getPartialTicks();

        double xIn = class_3532.method_16436(pt, cart.field_6038, cart.method_23317());
        double yIn = class_3532.method_16436(pt, cart.field_5971, cart.method_23318());
        double zIn = class_3532.method_16436(pt, cart.field_5989, cart.method_23321());

        float yaw = class_3532.method_16439(pt, cart.field_5982, cart.method_36454());
        float pitch = class_3532.method_16439(pt, cart.field_6004, cart.method_36455());
        float roll = cart.method_54295() - pt;

        float rollAmplifier = cart.method_54294() - pt;
        if (rollAmplifier < 0.0F)
            rollAmplifier = 0.0F;
        roll = roll > 0 ? class_3532.method_15374(roll) * roll * rollAmplifier / 10.0F * cart.method_54296() : 0;

        class_243 positionVec = new class_243(xIn, yIn, zIn);
        class_243 frontVec = positionVec.method_1019(VecHelper.rotate(new class_243(.5, 0, 0), 180 - yaw, class_2350.class_2351.field_11052));
        class_243 backVec = positionVec.method_1019(VecHelper.rotate(new class_243(-.5, 0, 0), 180 - yaw, class_2350.class_2351.field_11052));

        if (cart.method_61569() instanceof class_9883 defaultMinecartController) {
            class_243 railVecOfPos = defaultMinecartController.method_61620(xIn, yIn, zIn);
            if (railVecOfPos != null) {
                frontVec = defaultMinecartController.method_61619(xIn, yIn, zIn, 0.3F);
                backVec = defaultMinecartController.method_61619(xIn, yIn, zIn, -0.3F);
                if (frontVec == null)
                    frontVec = railVecOfPos;
                if (backVec == null)
                    backVec = railVecOfPos;

                x += railVecOfPos.field_1352;
                y += (frontVec.field_1351 + backVec.field_1351) / 2;
                z += railVecOfPos.field_1350;

                class_243 endPointDiff = backVec.method_1031(-frontVec.field_1352, -frontVec.field_1351, -frontVec.field_1350);
                if (endPointDiff.method_1033() != 0.0D) {
                    endPointDiff = endPointDiff.method_1029();
                    yaw = (float) (Math.atan2(endPointDiff.field_1350, endPointDiff.field_1352) * 180.0D / Math.PI);
                    pitch = (float) (Math.atan(endPointDiff.field_1351) * 73.0D);
                }
            } else {
                x += xIn;
                y += yIn;
                z += zIn;
            }
        } else {
            x += xIn;
            y += yIn;
            z += zIn;
        }

        final float offsetMagnitude = 13 / 16f;
        boolean isBackFaceCloser = frontVec.method_1025(centerOfCoupling) > backVec.method_1025(centerOfCoupling);
        float offset = isBackFaceCloser ? -offsetMagnitude : offsetMagnitude;

        return new CartEndpoint(x, y + 2 / 16f, z, 180 - yaw, -pitch, roll, offset, isBackFaceCloser);
    }

    static class CartEndpoint {

        double x;
        double y;
        double z;
        float yaw;
        float pitch;
        float roll;
        float offset;
        boolean flip;

        public CartEndpoint(double x, double y, double z, float yaw, float pitch, float roll, float offset, boolean flip) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
            this.offset = offset;
            this.flip = flip;
        }

        public class_243 apply(class_243 vec) {
            vec = vec.method_1031(offset, 0, 0);
            vec = VecHelper.rotate(vec, roll, class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, pitch, class_2350.class_2351.field_11051);
            vec = VecHelper.rotate(vec, yaw, class_2350.class_2351.field_11052);
            return vec.method_1031(x, y, z);
        }

        public void apply(class_4587 ms, class_243 camera) {
            TransformStack.of(ms).translate(camera.method_1021(-1).method_1031(x, y, z)).rotateYDegrees(yaw).rotateZDegrees(pitch).rotateXDegrees(roll)
                .translate(offset, 0, 0).rotateYDegrees(flip ? 180 : 0);
        }

    }

    public static void doDebugRender(Couple<MinecartController> c) {
        int yOffset = 1;
        MinecartController first = c.getFirst();
        class_1688 mainCart = first.cart();
        class_243 mainCenter = mainCart.method_73189().method_1031(0, yOffset, 0);
        class_243 connectedCenter = c.getSecond().cart().method_73189().method_1031(0, yOffset, 0);

        int color = Color.mixColors(
            0xabf0e9,
            0xee8572,
            (float) class_3532.method_15350(Math.abs(first.getCouplingLength(true) - connectedCenter.method_1022(mainCenter)) * 8, 0, 1)
        );

        Outliner.getInstance().showLine(mainCart.method_5628() + "", mainCenter, connectedCenter).colored(color).lineWidth(1 / 8f);

        class_243 point = mainCart.method_73189().method_1031(0, yOffset, 0);
        Outliner.getInstance().showLine(mainCart.method_5628() + "_dot", point, point.method_1031(0, 1 / 128f, 0)).colored(0xffffff).lineWidth(1 / 4f);
    }

}
