package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption.RenderedBlocks;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper.BlockEntityListRenderState;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_10017;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_897;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends ContraptionEntityRenderer.AbstractContraptionState> extends class_897<C, S> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment<>();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final class_4587 matrixStack;

    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.matrixStack = new class_4587();
    }

    public static SuperByteBuffer getBuffer(
        Contraption contraption,
        ClientContraption clientContraption,
        VirtualRenderWorld renderWorld,
        class_11515 renderType
    ) {
        return SuperByteBufferCache.getInstance()
            .get(CONTRAPTION, Pair.of(contraption, renderType), () -> buildStructureBuffer(clientContraption, renderWorld, renderType));
    }

    @SuppressWarnings("unchecked")
    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<ClientContraption> clientContraption = (AtomicReference<ClientContraption>) contraption.clientContraption;
        var out = clientContraption.getAcquire();
        if (out == null) {
            // Another thread may hit this block in the same moment.
            // One thread will win and the ContraptionRenderInfo that
            // it generated will become canonical. It's important that
            // we only maintain one RenderInfo instance, specifically
            // for the VirtualRenderWorld inside.
            clientContraption.compareAndExchangeRelease(null, createClientContraption(contraption));

            // Must get again to ensure we have the canonical instance.
            out = clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    @SuppressWarnings("removal")
    private static SuperByteBuffer buildStructureBuffer(
        ClientContraption clientContraption,
        VirtualRenderWorld renderWorld,
        class_11515 layer
    ) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();

        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        RenderedBlocks blocks = clientContraption.getRenderedBlocks();

        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();

        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() == class_2464.field_11458) {
                class_1087 model = dispatcher.method_3349(state);
                long randomSeed = state.method_26190(pos);
                random.method_43052(randomSeed);
                if (class_4696.method_23679(state) == layer) {
                    poseStack.method_22903();
                    poseStack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    List<class_10889> parts = new ObjectArrayList<>();
                    if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
                        wrapper.addPartsWithInfo(renderWorld, pos, state, random, parts);
                    } else {
                        model.method_68513(random, parts);
                    }
                    renderer.method_3374(renderWorld, parts, state, pos, poseStack, sbbBuilder, true, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
        class_778.method_20545();

        return sbbBuilder.end();
    }

    @Override
    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (entity.getContraption() == null)
            return false;
        if (!entity.isAliveOrStale())
            return false;
        if (!entity.isReadyForRender())
            return false;

        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_55269() {
        return (S) new AbstractContraptionState();
    }

    @Override
    public void extractRenderState(C entity, S state, float tickProgress) {
        state.field_58171 = entity.method_5864();
        Contraption contraption = entity.getContraption();
        ClientContraption clientContraption = contraption != null ? getOrCreateClientContraptionLazy(contraption) : null;
        if (clientContraption == null) {
            return;
        }
        class_4184 camera = field_4676.field_4686;
        if (camera == null) {
            return;
        }
        state.contraption = contraption;
        state.field_53325 = class_3532.method_16436(tickProgress, entity.field_6038, entity.method_23317());
        state.field_53326 = class_3532.method_16436(tickProgress, entity.field_5971, entity.method_23318());
        state.field_53327 = class_3532.method_16436(tickProgress, entity.field_5989, entity.method_23321());
        class_1937 world = entity.method_73183();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        ContraptionMatrices matrices = clientContraption.getMatrices();
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_71156();
        matrixStack.method_22904(state.field_53325 - cameraPos.field_1352, state.field_53326 - cameraPos.field_1351, state.field_53327 - cameraPos.field_1350);
        matrices.setup(this, matrixStack, state);
        class_4587 projection = new class_4587();
        projection.method_23760().method_66521(matrices.getModelViewProjection().method_23760());
        Matrix4f lightMatrix4f = new Matrix4f(matrices.getLight());
        Matrix4f worldMatrix4f = new Matrix4f(matrices.getWorld());
        matrices.clear();
        matrixStack.method_22909();
        boolean support = VisualizationManager.supportsVisualization(world);
        if (!support) {
            state.block = ContraptionBlockRenderState.create(contraption, clientContraption, renderWorld, projection, world, worldMatrix4f);
        }
        var adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        state.blockEntity = BlockEntityRenderHelper.getBlockEntitiesRenderState(
            support,
            clientContraption.renderedBlockEntityView,
            adjustRenderedBlockEntities,
            clientContraption.scratchErroredBlockEntities,
            renderWorld,
            world,
            projection,
            lightMatrix4f,
            contraption.entity.toLocalVector(cameraPos, tickProgress),
            tickProgress
        );
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        state.actor = ActorListRenderState.create(cameraPos, method_3932(), world, renderWorld, contraption, worldMatrix4f, projection);
    }

    @Override
    public void submit(S state, class_4587 poseStack, class_11659 queue, class_12075 cameraRenderState) {
        if (state.contraption == null) {
            return;
        }
        if (state.block != null) {
            state.block.render(queue);
        }
        if (state.blockEntity != null) {
            state.blockEntity.render(queue, cameraRenderState);
        }
        if (state.actor != null) {
            state.actor.render(queue);
        }
    }

    public void transform(S state, class_4587 matrixStack) {
    }

    public static class AbstractContraptionState extends class_10017 {
        public Contraption contraption;
        public ContraptionBlockRenderState block;
        public BlockEntityListRenderState blockEntity;
        public ActorListRenderState actor;
    }

    public record ContraptionBlockRenderState(class_4587 matrices, List<ContraptionBlockLayer> layers) {
        @Nullable
        public static ContraptionBlockRenderState create(
            Contraption contraption,
            ClientContraption clientContraption,
            VirtualRenderWorld renderWorld,
            class_4587 matrices,
            class_1937 world,
            Matrix4f lightTransform
        ) {
            List<ContraptionBlockLayer> layers = new ArrayList<>();
            for (class_11515 blockLayer : class_11515.values()) {
                SuperByteBuffer buffer = getBuffer(contraption, clientContraption, renderWorld, blockLayer);
                if (buffer.isEmpty()) {
                    continue;
                }
                layers.add(new ContraptionBlockLayer(getRenderLayer(blockLayer), buffer, world, lightTransform));
            }
            if (layers.isEmpty()) {
                return null;
            }
            return new ContraptionBlockRenderState(matrices, layers);
        }

        private static class_1921 getRenderLayer(class_11515 layer) {
            return switch (layer) {
                case field_60923 -> class_12249.method_75965();
                case field_60925 -> class_12249.method_75972();
                case field_60926 -> class_12249.method_75977();
                case field_60927 -> class_12249.method_76009();
            };
        }

        public void render(class_11659 queue) {
            for (ContraptionBlockLayer layer : layers) {
                queue.method_73483(matrices, layer.renderLayer, layer);
            }
        }
    }


    public record ContraptionBlockLayer(
        class_1921 renderLayer, SuperByteBuffer buffer, class_1937 world, Matrix4f lightTransform
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            buffer.useLevelLight(world, lightTransform).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public record ActorListRenderState(class_4587 matrices, List<MovementRenderState> actors) {
        @Nullable
        public static ActorListRenderState create(
            class_243 camera,
            class_327 textRenderer,
            class_1937 world,
            VirtualRenderWorld renderWorld,
            Contraption contraption,
            Matrix4f worldMatrix4f,
            class_4587 viewProjection
        ) {
            List<MovementRenderState> actors = new ArrayList<>();
            for (Pair<class_3499.class_3501, MovementContext> actor : contraption.getActors()) {
                MovementContext context = actor.getRight();
                if (context == null) {
                    continue;
                }
                if (context.world == null) {
                    context.world = world;
                }
                MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get(context.state);
                if (movementBehaviour != null) {
                    MovementRenderBehaviour render = movementBehaviour.getAttachRender();
                    if (render == null || contraption.isHiddenInPortal(context.localPos)) {
                        continue;
                    }
                    MovementRenderState renderState = render.getRenderState(camera, textRenderer, context, renderWorld, worldMatrix4f);
                    if (renderState != null) {
                        actors.add(renderState);
                    }
                }
            }
            if (actors.isEmpty()) {
                return null;
            }
            return new ActorListRenderState(viewProjection, actors);
        }

        public void render(class_11659 queue) {
            for (MovementRenderState actor : actors) {
                matrices.method_22903();
                actor.transform(matrices);
                actor.render(matrices, queue);
                matrices.method_22909();
            }
        }
    }

    @SuppressWarnings("removal")
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();
    }
}
