package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer.AbstractContraptionState;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

/**
 * <p>
 * ContraptionMatrices must be cleared and setup per-contraption per-frame
 * </p>
 */
public class ContraptionMatrices {

    private final class_4587 modelViewProjection = new class_4587();
    private final class_4587 viewProjection = new class_4587();
    private final class_4587 model = new class_4587();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();

    <S extends AbstractContraptionState> void setup(ContraptionEntityRenderer<?, S> renderer, class_4587 viewProjection, S state) {
        this.viewProjection.method_22903();
        transform(this.viewProjection, viewProjection);
        model.method_22903();
        renderer.transform(state, model);

        modelViewProjection.method_22903();
        transform(modelViewProjection, viewProjection);
        transform(modelViewProjection, model);

        translateToEntity(world, state);

        light.set(world);
        light.mul(model.method_23760().method_23761());
    }

    void clear() {
        clearStack(modelViewProjection);
        clearStack(viewProjection);
        clearStack(model);
        world.identity();
        light.identity();
    }

    public class_4587 getModelViewProjection() {
        return modelViewProjection;
    }

    public class_4587 getViewProjection() {
        return viewProjection;
    }

    public class_4587 getModel() {
        return model;
    }

    public Matrix4f getWorld() {
        return world;
    }

    public Matrix4f getLight() {
        return light;
    }

    public static void transform(class_4587 ms, class_4587 transform) {
        ms.method_23760().method_23761().mul(transform.method_23760().method_23761());
        ms.method_23760().method_23762().mul(transform.method_23760().method_23762());
    }

    public static void translateToEntity(Matrix4f matrix, AbstractContraptionState state) {
        matrix.setTranslation((float) state.field_53325, (float) state.field_53326, (float) state.field_53327);
    }

    public static void clearStack(class_4587 ms) {
        while (!ms.method_67795()) {
            ms.method_22909();
        }
    }

}
