package com.zurrtum.create.client.content.contraptions.wrench;


import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.render.DirectionIndicatorRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderer;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.infrastructure.packet.c2s.RadialWrenchMenuSubmitPacket;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

import java.util.*;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class RadialWrenchMenu extends AbstractSimiScreen {

    public static final Map<class_2769<?>, String> VALID_PROPERTIES = new HashMap<>();

    static {
        registerRotationProperty(RotatedPillarKineticBlock.AXIS, "Axis");
        registerRotationProperty(DirectionalKineticBlock.FACING, "Facing");
        registerRotationProperty(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, "Axis");
        registerRotationProperty(HorizontalKineticBlock.HORIZONTAL_FACING, "Facing");
        registerRotationProperty(class_2377.field_11129, "Facing");
        registerRotationProperty(DirectedDirectionalBlock.TARGET, "Target");

        registerRotationProperty(SequencedGearshiftBlock.VERTICAL, "Vertical");
    }

    public static final Set<class_2960> BLOCK_BLACKLIST = new HashSet<>();

    static {
        registerBlacklistedBlock(class_7923.field_41175.method_10221(AllBlocks.LARGE_WATER_WHEEL));
        registerBlacklistedBlock(class_7923.field_41175.method_10221(AllBlocks.WATER_WHEEL_STRUCTURAL));
    }

    public static void registerRotationProperty(class_2769<?> property, String label) {
        if (VALID_PROPERTIES.containsKey(property))
            return;

        VALID_PROPERTIES.put(property, label);
    }

    public static void registerBlacklistedBlock(class_2960 location) {
        if (BLOCK_BLACKLIST.contains(location))
            return;

        BLOCK_BLACKLIST.add(location);
    }

    private final class_2680 state;
    private final class_2338 pos;
    private final class_2586 blockEntity;
    private final class_1937 level;
    private final NonVisualizationLevel nonVisualizationLevel;
    private final List<Map.Entry<class_2769<?>, String>> propertiesForState;
    private final int innerRadius = 50;
    private final int outerRadius = 110;

    private int selectedPropertyIndex = 0;
    private List<class_2680> allStates = List.of();
    private String propertyLabel = "";
    private int ticksOpen;
    private int selectedStateIndex = 0;

    private final RenderElement iconScroll = RenderElement.of(PonderGuiTextures.ICON_SCROLL);
    private final RenderElement iconUp = RenderElement.of(AllIcons.I_PRIORITY_HIGH);
    private final RenderElement iconDown = RenderElement.of(AllIcons.I_PRIORITY_LOW);

    public static Optional<RadialWrenchMenu> tryCreateFor(class_2680 state, class_2338 pos, class_1937 level) {
        if (BLOCK_BLACKLIST.contains(class_7923.field_41175.method_10221(state.method_26204())))
            return Optional.empty();

        var propertiesForState = VALID_PROPERTIES.entrySet().stream().filter(entry -> state.method_28498(entry.getKey())).toList();

        if (propertiesForState.isEmpty())
            return Optional.empty();

        return Optional.of(new RadialWrenchMenu(state, pos, level, propertiesForState));
    }

    private RadialWrenchMenu(class_2680 state, class_2338 pos, class_1937 level, List<Map.Entry<class_2769<?>, String>> properties) {
        this.state = state;
        this.pos = pos;
        this.level = level;
        this.nonVisualizationLevel = new NonVisualizationLevel(level);
        this.blockEntity = level.method_8321(pos);
        this.propertiesForState = properties;

        initForSelectedProperty();
    }

    private void initForSelectedProperty() {
        Map.Entry<class_2769<?>, String> entry = propertiesForState.get(selectedPropertyIndex);

        allStates = new ArrayList<>();
        //allStates.add(state);
        cycleAllPropertyValues(state, entry.getKey(), allStates);

        propertyLabel = entry.getValue();
    }

    private void cycleAllPropertyValues(class_2680 state, class_2769<?> property, List<class_2680> states) {
        Optional<? extends Comparable<?>> first = property.method_11898().stream().findFirst();
        if (first.isEmpty())
            return;

        int offset = 0;
        int safety = 100;
        while (safety-- > 0) {
            if (state.method_11654(property).equals(first.get())) {
                offset = 99 - safety;
                break;
            }

            state = state.method_28493(property);
        }

        safety = 100;
        while (safety-- > 0) {
            if (states.contains(state))
                break;

            states.add(state);

            state = state.method_28493(property);
        }

        offset = class_3532.method_15340(offset, 0, states.size() - 1);
        selectedStateIndex = (offset == 0) ? 0 : (states.size() - offset);
    }

    @Override
    public void method_25393() {
        ticksOpen++;
        if (field_22787 != null && !level.method_8320(pos).method_27852(state.method_26204())) {
            field_22787.method_1507(null);
        }
        super.method_25393();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;

        Matrix3x2fStack ms = graphics.method_51448();

        ms.pushMatrix();
        ms.translate(x, y);

        int mouseOffsetX = mouseX - this.field_22789 / 2;
        int mouseOffsetY = mouseY - this.field_22790 / 2;

        if (class_3532.method_61344(mouseOffsetX, mouseOffsetY) > innerRadius - 5) {
            double theta = class_3532.method_15349(mouseOffsetX, mouseOffsetY);

            float sectorSize = 360f / allStates.size();

            selectedStateIndex = (int) Math.floor(((-AngleHelper.deg(class_3532.method_15349(
                mouseOffsetX,
                mouseOffsetY
            )) + 180 + sectorSize / 2) % 360) / sectorSize);

            renderDirectionIndicator(graphics, theta);
        }

        renderRadialSectors(graphics);

        UIRenderHelper.streak(graphics, 0, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));
        UIRenderHelper.streak(graphics, 180, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));

        if (selectedPropertyIndex > 0) {
            iconScroll.at(-14, -46).render(graphics);
            iconUp.at(-1, -46).render(graphics);
            graphics.method_25300(
                field_22793,
                propertiesForState.get(selectedPropertyIndex - 1).getValue(),
                0,
                -30,
                UIRenderHelper.COLOR_TEXT.getFirst().getRGB()
            );
        }

        if (selectedPropertyIndex < propertiesForState.size() - 1) {
            iconScroll.at(-14, 30).render(graphics);
            iconDown.at(-1, 30).render(graphics);
            graphics.method_25300(
                field_22793,
                propertiesForState.get(selectedPropertyIndex + 1).getValue(),
                0,
                22,
                UIRenderHelper.COLOR_TEXT.getFirst().getRGB()
            );
        }

        graphics.method_25300(field_22793, "Currently", 0, -13, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());
        graphics.method_25300(field_22793, "Changing:", 0, -3, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());
        graphics.method_25300(field_22793, propertyLabel, 0, 7, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());

        ms.popMatrix();

    }

    private void renderRadialSectors(class_332 graphics) {
        int sectors = allStates.size();
        if (sectors < 2)
            return;

        Matrix3x2fStack poseStack = graphics.method_51448();
        class_746 player = field_22787.field_1724;
        if (player == null)
            return;

        float sectorAngle = 360f / sectors;
        int sectorWidth = outerRadius - innerRadius;

        poseStack.pushMatrix();

        for (int i = 0; i < sectors; i++) {
            Color innerColor = Color.WHITE.setAlpha(0.05f);
            Color outerColor = Color.WHITE.setAlpha(0.3f);
            class_2680 blockState = allStates.get(i);
            class_2769<?> property = propertiesForState.get(selectedPropertyIndex).getKey();

            poseStack.pushMatrix();

            if (i == selectedStateIndex) {
                innerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.2f), 0.5f);
                outerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.6f), 0.5f);

                UIRenderHelper.drawRadialSector(
                    graphics,
                    outerRadius + 2,
                    outerRadius + 3,
                    -(sectorAngle / 2 + 90),
                    sectorAngle,
                    outerColor,
                    outerColor
                );
            }

            UIRenderHelper.drawRadialSector(graphics, innerRadius, outerRadius, -(sectorAngle / 2 + 90), sectorAngle, innerColor, outerColor);
            Color c = innerColor.copy().setAlpha(0.5f);
            UIRenderHelper.drawRadialSector(graphics, innerRadius - 3, innerRadius - 2, -(sectorAngle / 2 + 90), sectorAngle, c, c);

            poseStack.translate(0, -(sectorWidth / 2f + innerRadius));
            poseStack.rotate(class_3532.field_29847 * (-i * sectorAngle));

            graphics.field_59826.method_70922(EntityBlockRenderState.create(
                i,
                graphics,
                nonVisualizationLevel,
                pos,
                blockEntity,
                blockState,
                -21,
                -21,
                1.5f,
                17,
                player.method_36455(),
                player.method_36454() + 180,
                0
            ));

            if (i == selectedStateIndex) {
                graphics.method_25300(field_22793, blockState.method_11654(property).toString(), 0, 15, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());
            }

            poseStack.popMatrix();

            poseStack.pushMatrix();

            poseStack.rotate(class_3532.field_29847 * sectorAngle / 2);

            poseStack.translate(0, -innerRadius - 20);

            UIRenderHelper.angledGradient(graphics, -90, 0, 0, 0.5f, sectorWidth - 10, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            UIRenderHelper.angledGradient(graphics, 90, 0, 0, 0.5f, 25, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            poseStack.popMatrix();

            poseStack.rotate(class_3532.field_29847 * sectorAngle);
        }

        poseStack.popMatrix();

    }

    private void renderDirectionIndicator(class_332 graphics, double theta) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.rotate((float) -theta);
        poseStack.translate(0, innerRadius + 3);
        graphics.field_59826.method_70919(new DirectionIndicatorRenderState(new Matrix3x2f(poseStack), 0.8f, 0.8f, 0.8f));
        poseStack.popMatrix();
    }

    private void submitChange() {
        class_2680 selectedState = allStates.get(selectedStateIndex);
        if (selectedState != state) {
            field_22787.field_1724.field_3944.method_52787(new RadialWrenchMenuSubmitPacket(pos, selectedState));
        }
        method_25419();
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1, (ticksOpen + AnimationTickHolder.getPartialTicks()) / 20f));

        guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, color.getRGB(), color.getRGB());
    }

    @Override
    public boolean method_16803(class_11908 input) {
        if (AllKeys.ROTATE_MENU.method_1417(input)) {
            submitChange();
            return true;
        }
        return super.method_16803(input);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        int button = click.method_74245();
        if (button == 0) {
            submitChange();
            return true;
        } else if (button == 1) {
            method_25419();
            return true;
        }

        return super.method_25402(click, doubled);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (propertiesForState.size() < 2)
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);

        int indexDelta = (int) Math.round(Math.signum(-scrollY));

        int newIndex = selectedPropertyIndex + indexDelta;
        if (newIndex < 0)
            return false;

        if (newIndex >= propertiesForState.size())
            return false;

        selectedPropertyIndex = newIndex;
        initForSelectedProperty();

        return true;
    }

    @Override
    public void method_25432() {
        RadialWrenchHandler.COOLDOWN = 2;
        for (int i = 0, size = allStates.size(); i < size; i++) {
            EntityBlockRenderer.clear(i);
        }

        super.method_25432();
    }
}
